/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.meadow.client.renderer.block.PineSignRenderer;
import net.satisfy.meadow.core.block.entity.PineSignBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class PineHangingSignRenderer
extends PineSignRenderer {
    private static final String PLANK = "plank";
    private static final String V_CHAINS = "vChains";
    private static final String NORMAL_CHAINS = "normalChains";
    private static final String CHAIN_L_1 = "chainL1";
    private static final String CHAIN_L_2 = "chainL2";
    private static final String CHAIN_R_1 = "chainR1";
    private static final String CHAIN_R_2 = "chainR2";
    private static final String BOARD = "board";
    private static final float MODEL_RENDER_SCALE = 1.0f;
    private static final float TEXT_RENDER_SCALE = 0.9f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, (double)-0.32f, (double)0.073f);
    private final Map hangingSignModels = (Map)WoodType.values().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> new HangingSignModel(context.bakeLayer(ModelLayers.createHangingSignModelName((WoodType)woodType)))));

    public PineHangingSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public float getSignModelRenderScale() {
        return 1.0f;
    }

    @Override
    public float getSignTextRenderScale() {
        return 0.9f;
    }

    @Override
    public void render(PineSignBlockEntity signBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState blockState = signBlockEntity.getBlockState();
        SignBlock signBlock = (SignBlock)blockState.getBlock();
        WoodType woodType = SignBlock.getWoodType((Block)signBlock);
        HangingSignModel hangingSignModel = (HangingSignModel)((Object)this.hangingSignModels.get(woodType));
        hangingSignModel.evaluateVisibleParts(blockState);
        this.renderSignWithText(signBlockEntity, poseStack, multiBufferSource, i, j, blockState, signBlock, woodType, hangingSignModel);
    }

    @Override
    void translateSign(PoseStack poseStack, float f, BlockState blockState) {
        poseStack.translate(0.5, 0.9375, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        poseStack.translate(0.0f, -0.3125f, 0.0f);
    }

    @Override
    void renderSignModel(PoseStack poseStack, int i, int j, Model model, VertexConsumer vertexConsumer) {
        HangingSignModel hangingSignModel = (HangingSignModel)model;
        hangingSignModel.root.render(poseStack, vertexConsumer, i, j);
    }

    @Override
    Material getSignMaterial(WoodType woodType) {
        return Sheets.getHangingSignMaterial((WoodType)woodType);
    }

    @Override
    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    public static LayerDefinition createHangingSignLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOARD, CubeListBuilder.create().texOffs(0, 12).addBox(-7.0f, 0.0f, -1.0f, 14.0f, 10.0f, 2.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(PLANK, CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -6.0f, -2.0f, 16.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild(NORMAL_CHAINS, CubeListBuilder.create(), PartPose.ZERO);
        partDefinition2.addOrReplaceChild(CHAIN_L_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        partDefinition2.addOrReplaceChild(CHAIN_L_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        partDefinition2.addOrReplaceChild(CHAIN_R_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        partDefinition2.addOrReplaceChild(CHAIN_R_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        partDefinition.addOrReplaceChild(V_CHAINS, CubeListBuilder.create().texOffs(14, 6).addBox(-6.0f, -6.0f, 0.0f, 12.0f, 6.0f, 0.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class HangingSignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart plank;
        public final ModelPart vChains;
        public final ModelPart normalChains;

        public HangingSignModel(ModelPart modelPart) {
            super(RenderType::entityCutoutNoCull);
            this.root = modelPart;
            this.plank = modelPart.getChild(PineHangingSignRenderer.PLANK);
            this.normalChains = modelPart.getChild(PineHangingSignRenderer.NORMAL_CHAINS);
            this.vChains = modelPart.getChild(PineHangingSignRenderer.V_CHAINS);
        }

        public void evaluateVisibleParts(BlockState blockState) {
            boolean bl;
            this.plank.visible = bl = !(blockState.getBlock() instanceof CeilingHangingSignBlock);
            this.vChains.visible = false;
            this.normalChains.visible = true;
            if (!bl) {
                boolean bl2 = (Boolean)blockState.getValue((Property)BlockStateProperties.ATTACHED);
                this.normalChains.visible = !bl2;
                this.vChains.visible = bl2;
            }
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
            this.root.render(poseStack, vertexConsumer, i, j, k);
        }
    }
}

