/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.entity.CheeseFormBlockEntity;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheeseFormBlock
extends BaseEntityBlock {
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");
    public static final BooleanProperty DONE = BooleanProperty.create((String)"done");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<CheeseFormBlock> CODEC = CheeseFormBlock.simpleCodec(CheeseFormBlock::new);
    private static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.0625, (double)0.3125, (double)0.0625, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.6875, (double)0.0, (double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375), Shapes.box((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125), Shapes.box((double)0.125, (double)0.0625, (double)0.8125, (double)0.875, (double)0.375, (double)0.875), Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.375, (double)0.1875), Shapes.box((double)0.125, (double)0.0625, (double)0.1875, (double)0.1875, (double)0.375, (double)0.8125), Shapes.box((double)0.8125, (double)0.0625, (double)0.1875, (double)0.875, (double)0.375, (double)0.8125), Shapes.box((double)0.4375, (double)0.125, (double)0.0625, (double)0.5625, (double)0.75, (double)0.125), Shapes.box((double)0.4375, (double)0.125, (double)0.875, (double)0.5625, (double)0.75, (double)0.9375), Shapes.box((double)0.4375, (double)0.75, (double)0.0625, (double)0.5625, (double)0.8125, (double)0.9375)});
    public static final Map<Direction, VoxelShape> DIRECTIONAL_SHAPES = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, BASE_SHAPE));
        }
    });

    public CheeseFormBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DONE, (Comparable)Boolean.valueOf(false))).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return DIRECTIONAL_SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            player.openMenu(state.getMenuProvider(world, pos));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CheeseFormBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.CHEESE_FORM_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (CheeseFormBlockEntity)be));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CheeseFormBlockEntity) {
                CheeseFormBlockEntity be = (CheeseFormBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CheeseFormBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)WORKING)).booleanValue()) {
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getY() + 0.7;
            double f = (double)pos.getZ() + 0.5;
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double h = random.nextDouble() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.0 : h;
            double j = random.nextDouble() * 9.0 / 16.0;
            double k = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.0 : h;
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i, e + j, f + k, 0.01, 0.01, 0.01);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WORKING, DONE, FACING});
    }
}

