/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClimbingRopeTopmountBlock
extends Block {
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0));

    public ClimbingRopeTopmountBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            for (int i = 1; i <= 12; ++i) {
                BlockPos blockPos = pos.relative(Direction.DOWN, i);
                if (!world.isLoaded(blockPos) || !world.getBlockState(blockPos).isAir()) continue;
                world.setBlockAndUpdate(blockPos, ((Block)ObjectRegistry.CLIMBING_ROPE.get()).defaultBlockState());
            }
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!world.isClientSide()) {
            if (Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN)) {
                return state;
            }
            world.destroyBlock(pos, true);
            return world.getBlockState(pos);
        }
        return state;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN) && world.isEmptyBlock(pos.below());
    }
}

