/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class TiledStoveBlockBench
extends Block {
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0)});
    public static final VoxelShape SHAPE_SMALL = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));

    public TiledStoveBlockBench(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_SMALL;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = GeneralUtil.onUse(level, player, hand, hit, 0.1);
        if (result.consumesAction()) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return GeneralUtil.onUse(level, player, InteractionHand.MAIN_HAND, hit, 0.1);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        GeneralUtil.onStateReplaced(world, pos);
    }
}

