/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.compat.jei.category.CheesePressCategory;
import net.satisfy.meadow.core.compat.jei.category.CookingCauldronCategory;
import net.satisfy.meadow.core.compat.jei.category.WoodCutterCategory;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.recipes.WoodcuttingRecipe;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class MeadowJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingCauldronCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CheesePressCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCutterCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List cookingHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.COOKING.get());
        ArrayList cookingRecipes = new ArrayList();
        cookingHolders.forEach(h -> cookingRecipes.add((CookingCauldronRecipe)h.value()));
        registration.addRecipes(CookingCauldronCategory.COOKING_CAULDRON, cookingRecipes);
        List cheeseHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.CHEESE.get());
        ArrayList cheeseRecipes = new ArrayList();
        cheeseHolders.forEach(h -> cheeseRecipes.add((CheeseFormRecipe)h.value()));
        registration.addRecipes(CheesePressCategory.CHEESE_PRESS, cheeseRecipes);
        List woodHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.WOODCUTTING.get());
        ArrayList woodRecipes = new ArrayList();
        woodHolders.forEach(h -> woodRecipes.add((WoodcuttingRecipe)h.value()));
        registration.addRecipes(WoodCutterCategory.WOODCUTTER, woodRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Meadow.identifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CheeseFormGuiHandler.class, (MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), CheesePressCategory.CHEESE_PRESS, 1, 2, 3, 36);
        registration.addRecipeTransferHandler(CookingCauldronGuiHandler.class, (MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), CookingCauldronCategory.COOKING_CAULDRON, 1, 6, 7, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.WOODCUTTER.get()).asItem().getDefaultInstance(), new RecipeType[]{WoodCutterCategory.WOODCUTTER});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.COOKING_CAULDRON.get()).asItem().getDefaultInstance(), new RecipeType[]{CookingCauldronCategory.COOKING_CAULDRON});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.CHEESE_FORM.get()).asItem().getDefaultInstance(), new RecipeType[]{CheesePressCategory.CHEESE_PRESS});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

