/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class CheeseFormRecipe
implements Recipe<RecipeInput> {
    private final Ingredient bucket;
    private final Ingredient ingredient;
    private final ItemStack result;

    public CheeseFormRecipe(Ingredient bucket, Ingredient ingredient, ItemStack result) {
        this.bucket = bucket;
        this.ingredient = ingredient;
        this.result = result;
    }

    public ItemStack assemble() {
        return this.assemble(null, null);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.bucket);
        defaultedList.add((Object)this.ingredient);
        return defaultedList;
    }

    public Ingredient bucket() {
        return this.bucket;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public boolean matches(RecipeInput inventory, Level level) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(List.of(inventory.getItem(1), inventory.getItem(2)));
        for (Ingredient ingredient : ingredients) {
            boolean matches = false;
            for (ItemStack stack : items) {
                if (!ingredient.test(stack)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack getResultItem() {
        return this.getResultItem(null);
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"meadow", (String)"cheese_form");
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.CHEESE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.CHEESE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CheeseFormRecipe> {
        public static final MapCodec<CheeseFormRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("bucket").forGetter(CheeseFormRecipe::bucket), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(CheeseFormRecipe::ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, CheeseFormRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CheeseFormRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CheeseFormRecipe::bucket, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CheeseFormRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, CheeseFormRecipe::new);

        @NotNull
        public MapCodec<CheeseFormRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CheeseFormRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

