/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.core.block.entity.CabinetBlockEntity;
import net.satisfy.meadow.core.block.entity.CheeseFormBlockEntity;
import net.satisfy.meadow.core.block.entity.CheeseRackBlockEntity;
import net.satisfy.meadow.core.block.entity.CompletionistBannerEntity;
import net.satisfy.meadow.core.block.entity.CookingCauldronBlockEntity;
import net.satisfy.meadow.core.block.entity.PineHangingSignBlockEntity;
import net.satisfy.meadow.core.block.entity.PineSignBlockEntity;
import net.satisfy.meadow.core.block.entity.StorageBlockEntity;
import net.satisfy.meadow.core.block.entity.StoveBlockEntity;
import net.satisfy.meadow.core.entity.ChairEntity;
import net.satisfy.meadow.core.entity.PineBoatEntity;
import net.satisfy.meadow.core.entity.PineChestBoatEntity;
import net.satisfy.meadow.core.entity.WaterBuffaloEntity;
import net.satisfy.meadow.core.entity.WoolyCowEntity;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.StorageTypeRegistry;
import net.satisfy.meadow.platform.PlatformHelper;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CookingCauldronBlockEntity>> COOKING_CAULDRON = EntityTypeRegistry.registerBlockEntity("cooking_cauldron", () -> BlockEntityType.Builder.of(CookingCauldronBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_CAULDRON.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CheeseFormBlockEntity>> CHEESE_FORM_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cheese_form", () -> BlockEntityType.Builder.of(CheeseFormBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_FORM.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CheeseRackBlockEntity>> CHEESE_RACK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cheese_rack", () -> BlockEntityType.Builder.of(CheeseRackBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_RACK.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("stove_block_entity", () -> BlockEntityType.Builder.of(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TILED_STOVE_SMOKER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> MEADOW_BANNER = EntityTypeRegistry.registerBlockEntity("meadow_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.MEADOW_BANNER.get(), (Block)ObjectRegistry.MEADOW_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PineSignBlockEntity>> MOD_SIGN = BLOCK_ENTITY_TYPES.register("mod_sign", () -> BlockEntityType.Builder.of(PineSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PINE_SIGN.get(), (Block)ObjectRegistry.PINE_WALL_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PineHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITY_TYPES.register("mod_hanging_sign", () -> BlockEntityType.Builder.of(PineHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PINE_HANGING_SIGN.get(), (Block)ObjectRegistry.PINE_WALL_HANGING_SIGN.get()}).build(null));
    public static final RegistrySupplier<EntityType<WaterBuffaloEntity>> WATER_BUFFALO = EntityTypeRegistry.registerEntity("water_buffalo", () -> EntityType.Builder.of(WaterBuffaloEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).build(Meadow.identifier("water_buffalo").toString()));
    public static final RegistrySupplier<EntityType<WoolyCowEntity>> WOOLY_COW = EntityTypeRegistry.registerEntity("wooly_cow", () -> EntityType.Builder.of(WoolyCowEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).build(Meadow.identifier("wooly_cow").toString()));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(Meadow.identifier("chair").toString()));
    public static final Supplier<EntityType<PineBoatEntity>> PINE_BOAT = PlatformHelper.registerBoatType("pine_boat", PineBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<PineChestBoatEntity>> PINE_CHEST_BOAT = PlatformHelper.registerBoatType("pine_chest_boat", PineChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);

    public static void registerCow(Supplier<? extends EntityType<? extends Animal>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, Cow::createAttributes);
    }

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(Meadow.identifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(Meadow.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerCow(WOOLY_COW);
        EntityTypeRegistry.registerCow(WATER_BUFFALO);
    }
}

