/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.itemblocker.mixins;

import com.github.bigenergy.itemblocker.Config;
import com.github.bigenergy.itemblocker.ItemBlocker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
extends AttachmentHolder
implements IBlockEntityExtension {
    @Shadow
    @Nullable
    protected Level level;
    @Shadow
    private BlockState blockState;

    @Shadow
    public abstract BlockPos getBlockPos();

    @Inject(at={@At(value="HEAD")}, method={"setChanged()V"})
    public void onMarkDirty(CallbackInfo ci) {
        block2: {
            block3: {
                if (!Config.BAN_CONTAINER.getAsBoolean() || !Config.testBanRate() || this.level == null) break block2;
                BlockEntityMixin blockEntityMixin = this;
                if (!(blockEntityMixin instanceof Container)) break block3;
                Container container = (Container)blockEntityMixin;
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ItemStack stack = container.getItem(i);
                    if (!ItemBlocker.shouldDelete(stack)) continue;
                    container.removeItemNoUpdate(i);
                }
                break block2;
            }
            IItemHandler cap = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBlockPos(), this.blockState, (BlockEntity)this, (Object)Direction.WEST);
            if (cap == null || !(cap instanceof IItemHandlerModifiable)) break block2;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (!ItemBlocker.shouldDelete(cap.getStackInSlot(i))) continue;
                ((IItemHandlerModifiable)cap).setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }
}

