/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.itemblocker.mixins;

import com.github.bigenergy.itemblocker.Config;
import com.github.bigenergy.itemblocker.ItemBlocker;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MerchantMenu.class})
public abstract class MerchantMenuMixin {
    @Inject(at={@At(value="RETURN")}, method={"getOffers"}, cancellable=true)
    private void getOffers(CallbackInfoReturnable<MerchantOffers> cir) {
        if (cir.getReturnValue() != null && Config.BAN_MERCHANT_TRADES.getAsBoolean()) {
            MerchantOffers returnedOffers = new MerchantOffers();
            ((MerchantOffers)cir.getReturnValue()).forEach(offer -> {
                if (!ItemBlocker.shouldDelete(offer.assemble())) {
                    returnedOffers.add(offer);
                }
            });
            cir.setReturnValue((Object)returnedOffers);
        }
    }
}

