/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.temperature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBiomeOverride;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public abstract class ModifierBase {
    private static final float COLDEST_BIOME_TEMP = -0.5f;
    private static final float HOTTEST_BIOME_TEMP = 2.0f;

    public float getPlayerInfluence(Player player) {
        return 0.0f;
    }

    public float getWorldInfluence(@Nullable Player player, Level world, BlockPos pos) {
        return 0.0f;
    }

    protected float getNormalizedTempForBiome(Level level, Biome biome) {
        ResourceLocation name = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
        JsonTemperatureBiomeOverride biomeInfo = TemperatureDataManager.getBiome(name);
        if (name != null && biomeInfo != null) {
            return this.clampNormalizeTemperature(biomeInfo.temperature);
        }
        return this.clampNormalizeTemperature(biome.getBaseTemperature());
    }

    protected float applyUndergroundEffect(float temperature, Level level, BlockPos pos, float undergroundTemperature) {
        if (level.dimensionType().hasCeiling()) {
            return temperature;
        }
        return Mth.lerp((float)WorldUtil.getUndergroundEffectAtPos(level, pos), (float)temperature, (float)undergroundTemperature);
    }

    protected float getHumidityForBiome(Level level, Biome biome) {
        ResourceLocation name = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
        JsonTemperatureBiomeOverride biomeInfo = TemperatureDataManager.getBiome(name);
        if (name != null && biomeInfo != null) {
            return biomeInfo.isDry ? 0.1f : 0.5f;
        }
        return biome.getModifiedClimateSettings().downfall();
    }

    protected float clampNormalizeTemperature(float temp) {
        return (Mth.clamp((float)temp, (float)-0.5f, (float)2.0f) - -0.5f) / 2.5f;
    }

    protected float normalizeToPositiveNegative(float value) {
        return value * 2.0f - 1.0f;
    }
}

