/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.effects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.RandomUtils;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ParticleTypeRegistry;

public class TemperatureBreathEffect {
    private static int delay = 200 + RandomUtils.nextInt((int)0, (int)200);
    private static int particleTicks;
    private static boolean reset;
    private static int updateTempTicks;
    private static float temperature;

    public static void tickPlay(Player player) {
        if (player == null || !player.isAlive() || player.isSpectator() || player.isCreative() || !player.level().getBlockState(BlockPos.containing((Position)player.getEyePosition())).isAir()) {
            return;
        }
        if (updateTempTicks-- < 0) {
            updateTempTicks = 20;
            temperature = TemperatureUtil.getWorldTemperature(player.level(), player.blockPosition());
        }
        if ((double)temperature >= Config.Baked.coldBreathEffectThreshold) {
            TemperatureBreathEffect.reset(player);
            return;
        }
        reset = false;
        if (delay-- <= 0) {
            delay = 200 + player.getRandom().nextInt(200);
            particleTicks = 17;
        }
        if (particleTicks > 0) {
            --particleTicks;
            Vec3 eyePosition = player.getEyePosition().subtract(0.0, 0.2, 0.0);
            if (player.isCrouching()) {
                eyePosition = eyePosition.subtract(0.0, 0.25, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                Vec3 trajectory = player.getLookAngle().yRot((player.level().random.nextFloat() - 0.5f) * 0.1f).normalize();
                Vec3 origin = eyePosition.add(trajectory.scale(0.5));
                player.level().addParticle((ParticleOptions)ParticleTypeRegistry.COLD_BREATH.get(), origin.x, origin.y, origin.z, trajectory.x, trajectory.y, trajectory.z);
            }
        }
    }

    public static void reset(Player player) {
        if (!reset) {
            delay = 200 + player.getRandom().nextInt(200);
            reset = true;
        }
    }
}

