/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.events;

import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.client.ClientHooks;
import sfiomn.legendarysurvivaloverhaul.client.effects.TemperatureBreathEffect;
import sfiomn.legendarysurvivaloverhaul.client.integration.sereneseasons.RenderSeasonCards;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderBlurOverlay;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderBodyDamageGui;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderTemperatureGui;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderTemperatureOverlay;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderThirstGui;
import sfiomn.legendarysurvivaloverhaul.client.render.RenderWetnessGui;
import sfiomn.legendarysurvivaloverhaul.client.sounds.TemperatureBreathSound;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.common.events.CommonNeoForgeEvents;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.network.payloads.DrinkBlockFluidMessage;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.KeyMappingRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

@EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientForgeEvents {
    public static boolean hasOpened = false;
    public static int warningPageDelay = 40;

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        MapItemSavedData mapData;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem()).equals((Object)ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)"calendar"))) {
            player.displayClientMessage(SereneSeasonsUtil.seasonTooltip(player.blockPosition(), player.level()), true);
        } else if (event.getItemStack().getItem() == Items.CLOCK) {
            player.displayClientMessage((Component)Component.literal((String)WorldUtil.timeInGame(Minecraft.getInstance())), true);
        } else if (event.getItemStack().getItem() == Items.COMPASS) {
            String compassLocation = ItemUtil.compassLocation((Entity)player);
            if (!compassLocation.isEmpty()) {
                player.displayClientMessage((Component)Component.literal((String)compassLocation), true);
            }
        } else if (Config.Baked.showCoordinateOnMap && event.getItemStack().getItem() == Items.FILLED_MAP && (mapData = MapItem.getSavedData((ItemStack)event.getItemStack(), (Level)event.getLevel())) != null) {
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarysurvivaloverhaul.filled_map.destination", (Object[])new Object[]{mapData.centerX, mapData.centerZ}), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onApplyBonemeal(BonemealEvent event) {
        Block plant = event.getLevel().getBlockState(event.getPos()).getBlock();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || BuiltInRegistries.BLOCK.getKey((Object)plant) == null) {
            return;
        }
        if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && !SereneSeasonsUtil.plantCanGrow(event.getLevel(), event.getPos(), event.getLevel().getBlockState(event.getPos()))) {
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarysurvivaloverhaul.bonemeal.not_correct_season"), true);
        }
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        JsonThirstBlock jsonFluidThirst;
        Player player;
        ThirstAttachment thirstAttachment;
        if (ClientForgeEvents.shouldApplyThirst(event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().getMainHandItem().isEmpty() && !(thirstAttachment = AttachmentUtil.getThirstAttachment(player = event.getEntity())).isHydrationLevelAtMax() && (jsonFluidThirst = ThirstUtil.getFluidThirstLookedAt(player, (float)(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) / 2.0))) != null && (jsonFluidThirst.hydration != 0 || jsonFluidThirst.saturation != 0.0f)) {
            CommonNeoForgeEvents.playerDrinkEffect(event.getEntity());
            DrinkBlockFluidMessage.sendToServer();
        }
    }

    @SubscribeEvent
    public static void preRenderGameOverlay(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.FOOD_LEVEL) && Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(MobEffectRegistry.COLD_HUNGER)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayEventHideDebugInfo(CustomizeGuiOverlayEvent.DebugText event) {
        Object line;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isCreative() || player.isSpectator() || !Config.Baked.hideInfoFromDebug) {
            return;
        }
        ListIterator<Object> it = event.getRight().listIterator();
        while (it.hasNext()) {
            line = (String)it.next();
            if (!((String)line).contains("Targeted")) continue;
            line = ((String)line).split(":")[0] + ":";
            it.remove();
            it.add(line);
        }
        it = event.getLeft().listIterator();
        while (it.hasNext()) {
            line = (String)it.next();
            if (((String)line).contains("XYZ:")) {
                line = Component.translatable((String)"message.legendarysurvivaloverhaul.warning_use_compass").getString();
                it.remove();
                it.add(line);
            }
            if (!((String)line).startsWith("Chunk:") && !((String)line).startsWith("Block:") && !((String)line).startsWith("Facing:")) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!Minecraft.getInstance().isPaused() && player != null) {
            if (Config.Baked.temperatureEnabled) {
                RenderTemperatureGui.updateTimer();
                RenderTemperatureOverlay.updateTemperatureEffect((Player)player);
                if (Config.Baked.coldBreathEffectThreshold != -1000.0) {
                    TemperatureBreathEffect.tickPlay((Player)player);
                }
                if (Config.Baked.breathingSoundEnabled) {
                    TemperatureBreathSound.tickPlay((Player)player);
                }
            }
            if (Config.Baked.wetnessEnabled) {
                RenderWetnessGui.updateTimer();
            }
            if (ClientForgeEvents.shouldApplyThirst((Player)player) && Config.Baked.lowHydrationEffect) {
                RenderBlurOverlay.updateBlurIntensity((Player)player);
            }
            if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && Config.Baked.ssSeasonCardsEnabled) {
                RenderSeasonCards.updateSeasonCardFading((Player)player);
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                RenderBodyDamageGui.updateFlashingTimer();
                if (KeyMappingRegistry.showBodyHealth.consumeClick()) {
                    ClientHooks.openBodyHealthScreen((Player)player);
                }
            }
            if (Config.Baked.thirstEnabled && Config.Baked.showDrinkPreview) {
                RenderThirstGui.updateTimer();
            }
            if (LegendarySurvivalOverhaul.curiosLoaded && player.tickCount % 10 == 0) {
                CuriosUtil.isThermometerEquipped = CuriosUtil.isCurioItemEquipped((Player)player, (Item)ItemRegistry.THERMOMETER.get());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && Config.Baked.lowHydrationEffect && ClientForgeEvents.shouldApplyThirst((Player)player)) {
            RenderBlurOverlay.render((Player)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide && event.getEntity() instanceof Player && LegendarySurvivalOverhaul.sereneSeasonsLoaded) {
            RenderSeasonCards.init();
        }
    }

    private static boolean shouldApplyThirst(Player player) {
        return Config.Baked.thirstEnabled && ThirstUtil.isThirstActive(player);
    }
}

