/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.integration.sereneseasons;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class RenderSeasonCards {
    private static final ResourceLocation SPRING_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/spring.png");
    private static final ResourceLocation AUTUMN_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/autumn.png");
    private static final ResourceLocation SUMMER_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/summer.png");
    private static final ResourceLocation WINTER_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/winter.png");
    private static final ResourceLocation DRY_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/dry.png");
    private static final ResourceLocation WET_CARD = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/cards/wet.png");
    private static final int CARD_WIDTH = 128;
    private static final int CARD_HEIGHT = 128;
    private static ResourceLocation seasonCard = null;
    private static Season lastSeason = null;
    private static SereneSeasonsUtil.TropicalSeason lastTropicalSeason = null;
    private static ResourceKey<Level> lastDimension = null;
    private static boolean isDimensionSeasonal;
    private static float fadeLevel;
    private static boolean fadeIn;
    private static int delayTimer;
    private static int cardTimer;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && Config.Baked.ssSeasonCardsEnabled && seasonCard != null) {
            int x = Mth.floor((float)((float)width / 2.0f - 64.0f));
            int y = Mth.floor((float)((float)height / 4.0f - 64.0f));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Minecraft.getInstance().getProfiler().push("season_card");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)seasonCard);
            RenderUtil.drawTexturedModelRectWithAlpha(guiGraphics.pose().last().pose(), x + Config.Baked.seasonCardsDisplayOffsetX, y + Config.Baked.seasonCardsDisplayOffsetY, 128, 128, 0, 0, 256, 256, fadeLevel);
            Minecraft.getInstance().getProfiler().pop();
            RenderSystem.disableBlend();
        }
    }

    public static void updateSeasonCardFading(Player player) {
        if (player == null || !player.isAlive()) {
            return;
        }
        Level level = player.level();
        if (lastDimension == null || lastDimension != level.dimension()) {
            delayTimer = Config.Baked.seasonCardsSpawnDimensionDelayInTicks;
            lastDimension = level.dimension();
            isDimensionSeasonal = SereneSeasonsUtil.hasSeasons(level);
        }
        if (!isDimensionSeasonal) {
            if (lastSeason != null || lastTropicalSeason != null) {
                RenderSeasonCards.reset();
            }
            return;
        }
        if (delayTimer > 0) {
            --delayTimer;
            return;
        }
        if (seasonCard == null) {
            SereneSeasonsUtil.TropicalSeason currentTropicalSeason;
            SereneSeasonsUtil.SeasonType seasonType = SereneSeasonsUtil.getSeasonType((Holder<Biome>)level.getBiome(player.blockPosition()));
            if (seasonType == SereneSeasonsUtil.SeasonType.NORMAL_SEASON) {
                Season currentSeason = SeasonHelper.getSeasonState((Level)level).getSeason();
                if (currentSeason != lastSeason) {
                    lastSeason = currentSeason;
                    fadeIn = true;
                    cardTimer = 0;
                    if (currentSeason == Season.AUTUMN) {
                        seasonCard = AUTUMN_CARD;
                    } else if (currentSeason == Season.SPRING) {
                        seasonCard = SPRING_CARD;
                    } else if (currentSeason == Season.SUMMER) {
                        seasonCard = SUMMER_CARD;
                    } else if (currentSeason == Season.WINTER) {
                        seasonCard = WINTER_CARD;
                    }
                }
            } else if (seasonType == SereneSeasonsUtil.SeasonType.TROPICAL_SEASON && (currentTropicalSeason = SereneSeasonsUtil.TropicalSeason.getTropicalSeason(SeasonHelper.getSeasonState((Level)level).getTropicalSeason())) != lastTropicalSeason) {
                lastTropicalSeason = currentTropicalSeason;
                fadeIn = true;
                cardTimer = 0;
                if (currentTropicalSeason == SereneSeasonsUtil.TropicalSeason.DRY) {
                    seasonCard = DRY_CARD;
                } else if (currentTropicalSeason == SereneSeasonsUtil.TropicalSeason.WET) {
                    seasonCard = WET_CARD;
                }
            }
        }
        if (seasonCard != null) {
            float targetFadeLevel = 0.0f;
            if (fadeIn) {
                targetFadeLevel = 1.0f;
            }
            if (targetFadeLevel > fadeLevel) {
                fadeLevel = Math.min(targetFadeLevel, fadeLevel + (float)Math.round(1.0f / (float)Config.Baked.seasonCardsFadeInInTicks * 100.0f) / 100.0f);
            }
            if (targetFadeLevel < fadeLevel) {
                fadeLevel = Math.max(targetFadeLevel, fadeLevel - (float)Math.round(1.0f / (float)Config.Baked.seasonCardsFadeOutInTicks * 100.0f) / 100.0f);
            }
            if (fadeLevel == 1.0f) {
                if (cardTimer++ >= Config.Baked.seasonCardsDisplayTimeInTicks) {
                    fadeIn = false;
                }
            } else if (fadeLevel == 0.0f) {
                seasonCard = null;
            }
        }
    }

    public static void reset() {
        lastSeason = null;
        lastTropicalSeason = null;
        seasonCard = null;
        fadeLevel = 0.0f;
    }

    public static void init() {
        seasonCard = null;
        lastSeason = null;
        lastTropicalSeason = null;
        lastDimension = null;
    }

    static {
        fadeLevel = 0.0f;
        delayTimer = 0;
        cardTimer = 0;
    }
}

