/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class RenderBodyDamageGui {
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/overlay.png");
    private static final int BODY_MODEL_TEXTURE_WIDTH = 16;
    private static final int BODY_MODEL_TEXTURE_HEIGHT = 32;
    private static final Map<BodyPartEnum, Integer> flashCounters = new HashMap<BodyPartEnum, Integer>();
    private static final Map<BodyPartEnum, Float> bodyPartHealth = new HashMap<BodyPartEnum, Float>();
    private static BodyDamageAttachment BODY_DAMAGE_CAP = null;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Config.Baked.localizedBodyDamageEnabled && !Minecraft.getInstance().options.hideGui && (player = Minecraft.getInstance().player) != null && !player.isCreative() && !player.isSpectator()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (BODY_DAMAGE_CAP == null || player.tickCount % 20 == 0) {
                BODY_DAMAGE_CAP = AttachmentUtil.getBodyDamageAttachment((Player)player);
            }
            if (BODY_DAMAGE_CAP.isWoundedBelow((float)Config.Baked.bodyDamageIndicatorRenderHealthLimit)) {
                Minecraft.getInstance().getProfiler().push("body_damage_gui");
                RenderBodyDamageGui.drawBodyDamage(guiGraphics, (Player)player, BODY_DAMAGE_CAP, width, height);
                Minecraft.getInstance().getProfiler().pop();
            }
            RenderSystem.disableBlend();
        }
    }

    public static void drawBodyDamage(GuiGraphics gui, Player player, BodyDamageAttachment cap, int width, int height) {
        int x = width / 2 + 92 + Config.Baked.bodyDamageIndicatorOffsetX;
        int y = height - 33 + Config.Baked.bodyDamageIndicatorOffsetY;
        if (!player.getOffhandItem().isEmpty() && player.getMainArm() == HumanoidArm.LEFT && Config.Baked.bodyDamageIndicatorOffsetX == 0 && Config.Baked.bodyDamageIndicatorOffsetY == 0) {
            x += 31;
        }
        for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
            if (!bodyPartHealth.containsKey((Object)bodyPart)) {
                bodyPartHealth.put(bodyPart, Float.valueOf(cap.getBodyPartDamage(bodyPart)));
            } else if (bodyPartHealth.get((Object)bodyPart).floatValue() != cap.getBodyPartDamage(bodyPart)) {
                flashCounters.put(bodyPart, 4);
                bodyPartHealth.put(bodyPart, Float.valueOf(cap.getBodyPartDamage(bodyPart)));
            }
            BodyPartIcon icon = BodyPartIcon.get(bodyPart);
            if (icon == null) continue;
            float healthRatio = cap.getBodyPartHealthRatio(bodyPart);
            boolean shouldFlash = flashCounters.containsKey((Object)bodyPart);
            BodyPartCondition offset = BodyPartCondition.get(healthRatio, shouldFlash);
            gui.blit(ICONS, x + icon.x, y + icon.y, 16 * offset.iconIndexX + icon.texX, 32 * offset.iconIndexY + icon.texY, icon.width, icon.height);
        }
    }

    public static void updateFlashingTimer() {
        Iterator<Map.Entry<BodyPartEnum, Integer>> iter = flashCounters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BodyPartEnum, Integer> flashBodyPart = iter.next();
            if (flashBodyPart.getValue() > 0) {
                flashBodyPart.setValue(flashBodyPart.getValue() - 1);
                continue;
            }
            iter.remove();
        }
    }

    private static enum BodyPartIcon {
        HEAD(4, 0, 4, 136, 8, 8),
        RIGHT_ARM(12, 8, 12, 144, 4, 12),
        LEFT_ARM(0, 8, 0, 144, 4, 12),
        CHEST(4, 8, 4, 144, 8, 12),
        RIGHT_LEG(8, 20, 8, 156, 4, 8),
        LEFT_LEG(4, 20, 4, 156, 4, 8),
        RIGHT_FOOT(8, 28, 8, 164, 4, 4),
        LEFT_FOOT(4, 28, 4, 164, 4, 4);

        public final int x;
        public final int y;
        public final int texX;
        public final int texY;
        public final int width;
        public final int height;

        private BodyPartIcon(int x, int y, int texX, int texY, int width, int height) {
            this.x = x;
            this.y = y;
            this.texX = texX;
            this.texY = texY;
            this.width = width;
            this.height = height;
        }

        public static BodyPartIcon get(BodyPartEnum bodyPart) {
            switch (bodyPart) {
                case HEAD: {
                    return HEAD;
                }
                case RIGHT_ARM: {
                    return RIGHT_ARM;
                }
                case LEFT_ARM: {
                    return LEFT_ARM;
                }
                case CHEST: {
                    return CHEST;
                }
                case RIGHT_LEG: {
                    return RIGHT_LEG;
                }
                case RIGHT_FOOT: {
                    return RIGHT_FOOT;
                }
                case LEFT_LEG: {
                    return LEFT_LEG;
                }
                case LEFT_FOOT: {
                    return LEFT_FOOT;
                }
            }
            return null;
        }
    }

    private static enum BodyPartCondition {
        HEALTHY(0, 0),
        SLIGHTLY_WOUNDED(1, 0),
        WOUNDED(2, 0),
        HEAVILY_WOUNDED(3, 0),
        DEAD(4, 0),
        HEALTHY_FLASH(0, 1),
        SLIGHTLY_WOUNDED_FLASH(1, 1),
        WOUNDED_FLASH(2, 1),
        HEAVILY_WOUNDED_FLASH(3, 1),
        DEAD_FLASH(4, 1);

        public final int iconIndexX;
        public final int iconIndexY;

        private BodyPartCondition(int iconIndexX, int iconIndexY) {
            this.iconIndexX = iconIndexX;
            this.iconIndexY = iconIndexY;
        }

        public static BodyPartCondition get(float healthRatio, boolean flash) {
            if (healthRatio >= 1.0f) {
                return flash ? HEALTHY_FLASH : HEALTHY;
            }
            if (healthRatio >= 0.66f) {
                return flash ? SLIGHTLY_WOUNDED_FLASH : SLIGHTLY_WOUNDED;
            }
            if (healthRatio >= 0.33f) {
                return flash ? WOUNDED_FLASH : WOUNDED;
            }
            if (healthRatio > 0.0f) {
                return flash ? HEAVILY_WOUNDED_FLASH : HEAVILY_WOUNDED;
            }
            return flash ? DEAD_FLASH : DEAD;
        }
    }
}

