/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.health.HealthAttachment;
import sfiomn.legendarysurvivaloverhaul.common.integration.overflowingbars.OverflowingBarsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class RenderHealthGui {
    public static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/overlay.png");
    private static final Random rand = new Random();
    private static final int HEART_TEXTURE_WIDTH = 9;
    private static final int HEART_TEXTURE_HEIGHT = 9;
    private static HealthAttachment HEALTH_CAP = null;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Config.Baked.healthOverhaulEnabled && !Minecraft.getInstance().options.hideGui && (player = Minecraft.getInstance().player) != null && !player.isCreative() && !player.isSpectator()) {
            rand.setSeed((long)player.tickCount * 445L);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            Minecraft.getInstance().getProfiler().push("health_gui");
            int leftHeight = gui.leftHeight;
            int used = RenderHealthGui.drawHealthBar(guiGraphics, (Player)player, width, height, leftHeight);
            if (used > 0) {
                gui.leftHeight += used;
            }
            Minecraft.getInstance().getProfiler().pop();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    public static int drawHealthBar(GuiGraphics gui, Player player, int width, int height, int leftHeight) {
        float shieldHealth;
        int brokenHearts;
        if (HEALTH_CAP == null || player.tickCount % 20 == 0) {
            HEALTH_CAP = AttachmentUtil.getHealthAttachment(player);
        }
        if ((float)(brokenHearts = HealthUtil.getEffectiveBrokenHearts(player)) + (shieldHealth = HEALTH_CAP.getShieldHealth()) == 0.0f) {
            return 0;
        }
        int left = width / 2 - 91;
        int top = height - leftHeight;
        int playerHearts = 0;
        int totalHearts = Mth.ceil((float)(shieldHealth / 2.0f)) + brokenHearts;
        boolean appendedRow = false;
        if (Config.Baked.appendBrokenShieldHeartsToHealthBar) {
            playerHearts = Mth.ceil((float)(player.getMaxHealth() / 2.0f));
            if (OverflowingBarsUtil.isHealthBarOverflowing()) {
                playerHearts = Math.min(10, playerHearts);
            }
            if ((playerHearts %= 10) > 0) {
                totalHearts += playerHearts;
                top += 10;
                appendedRow = true;
            }
        }
        int healthRows = Mth.ceil((float)((float)totalHearts / 10.0f));
        RenderHealthGui.renderHearts(gui, left, top, 10, playerHearts, brokenHearts, Mth.ceil((float)player.getHealth()), shieldHealth);
        int used = healthRows * 10 - (appendedRow ? 10 : 0);
        return Math.max(used, 0);
    }

    public static void renderHearts(GuiGraphics gui, int left, int top, int rowHeight, int playerHearts, int brokenHearts, int health, float shieldHealth) {
        int shieldHearts = Mth.ceil((double)((double)shieldHealth / 2.0));
        for (int i1 = playerHearts + shieldHearts + brokenHearts - 1; i1 >= playerHearts; --i1) {
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int x = left + k1 * 8;
            int y = top - j1 * rowHeight;
            if ((float)health + shieldHealth <= 4.0f) {
                y += rand.nextInt(2);
            }
            boolean bl = flag = i1 >= brokenHearts + playerHearts;
            if (flag) {
                RenderHealthGui.renderHeart(gui, HeartType.CONTAINER, x, y, 0, false);
                RenderHealthGui.renderHeart(gui, HeartType.SHIELD, x, y, 0, shieldHealth < (float)(shieldHearts * 2) && i1 == shieldHearts - 1);
                continue;
            }
            RenderHealthGui.renderHeart(gui, HeartType.BROKEN, x, y, 0, false);
        }
    }

    public static void renderHeart(GuiGraphics gui, HeartType heartType, int x, int y, int yTexture, boolean halfIcon) {
        if (heartType.isTextureBased()) {
            gui.blit(heartType.location, x, y, heartType.getX(halfIcon), yTexture, 9, 9);
        } else {
            gui.blitSprite(heartType.getSprite(halfIcon), x, y, 9, 9);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HeartType {
        CONTAINER(ResourceLocation.withDefaultNamespace((String)"hud/heart/container")),
        SHIELD(ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_full"), ResourceLocation.withDefaultNamespace((String)"hud/heart/absorbing_half")),
        BROKEN(ICONS, 0);

        private final ResourceLocation fullSprite;
        private final ResourceLocation halfSprite;
        private final ResourceLocation location;
        private final int index;

        private HeartType(ResourceLocation singleSprite) {
            this.fullSprite = singleSprite;
            this.halfSprite = null;
            this.location = null;
            this.index = 0;
        }

        private HeartType(ResourceLocation fullSprite, ResourceLocation halfSprite) {
            this.fullSprite = fullSprite;
            this.halfSprite = halfSprite;
            this.location = null;
            this.index = 0;
        }

        private HeartType(ResourceLocation location, int index) {
            this.location = location;
            this.index = index;
            this.fullSprite = null;
            this.halfSprite = null;
        }

        public boolean isTextureBased() {
            return this == BROKEN;
        }

        public ResourceLocation getSprite(boolean halfIcon) {
            if (this == SHIELD && halfIcon && this.halfSprite != null) {
                return this.halfSprite;
            }
            return this.fullSprite;
        }

        public int getX(boolean halfIcon) {
            return (16 + this.index) * 9;
        }
    }
}

