/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.common.effects.FrostbiteEffect;
import sfiomn.legendarysurvivaloverhaul.common.effects.HeatStrokeEffect;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class RenderTemperatureOverlay {
    private static final ResourceLocation FROSTBITE_EFFECT = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/freeze_effect.png");
    private static final ResourceLocation HEAT_STROKE_EFFECT = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/heat_effect.png");
    private static TemperatureAttachment TEMPERATURE_CAP = null;
    private static ResourceLocation temperatureEffect = null;
    private static float fadeLevel = 0.0f;
    private static boolean triggerTemperatureSoundEffect;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Config.Baked.temperatureEnabled && temperatureEffect != null && (player = Minecraft.getInstance().player) != null && temperatureEffect != null && !player.isCreative() && !player.isSpectator()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderUtil.renderTextureOverlay(guiGraphics, temperatureEffect, width, height, fadeLevel);
            RenderSystem.disableBlend();
        }
    }

    public static void updateTemperatureEffect(Player player) {
        if (player != null && player.isAlive()) {
            float targetFadeLevel;
            boolean heatstrokeLimit;
            if (TEMPERATURE_CAP == null || player.tickCount % 20 == 0) {
                TEMPERATURE_CAP = AttachmentUtil.getTempAttachment(player);
            }
            float temperature = TEMPERATURE_CAP.getTemperatureLevel();
            TemperatureEnum tempEnum = TEMPERATURE_CAP.getTemperatureEnum();
            boolean frostbiteLimit = temperature <= TemperatureEnum.FROSTBITE.getMiddle() + 1.0f;
            boolean bl = heatstrokeLimit = temperature >= TemperatureEnum.HEAT_STROKE.getMiddle() - 1.0f;
            if (Config.Baked.coldTemperatureOverlay && tempEnum == TemperatureEnum.FROSTBITE && !FrostbiteEffect.playerIsImmuneToFrost(player)) {
                temperatureEffect = FROSTBITE_EFFECT;
                if (frostbiteLimit) {
                    targetFadeLevel = 0.75f;
                    if (triggerTemperatureSoundEffect) {
                        triggerTemperatureSoundEffect = false;
                        player.playSound((SoundEvent)SoundRegistry.FROSTBITE.get(), 1.0f, 1.0f);
                    }
                } else {
                    targetFadeLevel = 0.35f;
                    triggerTemperatureSoundEffect = true;
                    if (fadeLevel == 0.0f) {
                        player.playSound((SoundEvent)SoundRegistry.FROSTBITE_EARLY.get(), 1.0f, 1.0f);
                    }
                }
            } else if (Config.Baked.heatTemperatureOverlay && tempEnum == TemperatureEnum.HEAT_STROKE && !HeatStrokeEffect.playerIsImmuneToHeat(player)) {
                temperatureEffect = HEAT_STROKE_EFFECT;
                if (heatstrokeLimit) {
                    targetFadeLevel = 0.6f;
                    if (triggerTemperatureSoundEffect) {
                        triggerTemperatureSoundEffect = false;
                        player.playSound((SoundEvent)SoundRegistry.HEAT_STROKE.get(), 1.0f, 1.0f);
                    }
                } else {
                    targetFadeLevel = 0.25f;
                    triggerTemperatureSoundEffect = true;
                    if (fadeLevel == 0.0f) {
                        player.playSound((SoundEvent)SoundRegistry.HEAT_STROKE_EARLY.get(), 1.0f, 1.0f);
                    }
                }
            } else {
                triggerTemperatureSoundEffect = true;
                targetFadeLevel = 0.0f;
            }
            if (targetFadeLevel > fadeLevel) {
                fadeLevel = Math.min(targetFadeLevel, fadeLevel + MathUtil.round(0.05f, 2));
            }
            if (targetFadeLevel < fadeLevel) {
                fadeLevel = Math.max(targetFadeLevel, fadeLevel - MathUtil.round(0.05f, 2));
            }
            if (fadeLevel == 0.0f) {
                temperatureEffect = null;
            }
        }
    }
}

