/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class RenderThirstGui {
    public static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/overlay.png");
    private static final Random rand = new Random();
    private static final int HYDRATION_TEXTURE_WIDTH = 9;
    private static final int HYDRATION_TEXTURE_HEIGHT = 9;
    private static final int EXHAUSTION_BAR_WIDTH = 81;
    private static ThirstAttachment THIRST_CAP = null;
    @Nullable
    private static Item heldItemOnPreview;
    private static int heldItemHydration;
    private static float heldItemSaturation;
    private static boolean heldItemThirst;
    private static float alphaPreview;
    private static float unclampedAlphaPreview;
    private static int alphaDirection;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Config.Baked.thirstEnabled && Config.Baked.showHydrationBar && !Minecraft.getInstance().options.hideGui && (player = Minecraft.getInstance().player) != null && !player.isCreative() && !player.isSpectator()) {
            if (!ThirstUtil.isThirstActive((Player)player)) {
                return;
            }
            rand.setSeed((long)player.tickCount * 445L);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            Minecraft.getInstance().getProfiler().push("thirst_gui");
            int rightHeight = gui.rightHeight;
            RenderThirstGui.drawHydrationBar(guiGraphics, (Player)player, width, height, rightHeight);
            gui.rightHeight += 10;
            Minecraft.getInstance().getProfiler().pop();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    public static void drawHydrationBar(GuiGraphics gui, Player player, int width, int height, int rightHeight) {
        if (THIRST_CAP == null || player.tickCount % 20 == 0) {
            THIRST_CAP = AttachmentUtil.getThirstAttachment(player);
        }
        ItemStack currentHeldItemStack = player.getMainHandItem();
        if (Config.Baked.showDrinkPreview) {
            int y;
            int x;
            boolean previousIsEdible;
            if (player.tickCount % 10 == 0) {
                JsonThirstConsumable jsonThirstConsumable = ThirstDataManager.getConsumable(currentHeldItemStack);
                heldItemHydration = jsonThirstConsumable != null ? jsonThirstConsumable.hydration : 0;
                heldItemSaturation = jsonThirstConsumable != null ? jsonThirstConsumable.saturation : 0.0f;
                heldItemThirst = jsonThirstConsumable != null && jsonThirstConsumable.effects.stream().anyMatch(jsonEffectParameter -> jsonEffectParameter.name.equals("legendarysurvivaloverhaul:thirst"));
            }
            boolean currentIsEdible = currentHeldItemStack.has(DataComponents.FOOD);
            boolean bl = previousIsEdible = heldItemOnPreview != null && heldItemOnPreview.components().has(DataComponents.FOOD);
            if (heldItemOnPreview == null || currentIsEdible != previousIsEdible) {
                heldItemOnPreview = currentHeldItemStack.getItem();
                RenderThirstGui.resetFlash();
            }
            if (heldItemHydration == 0 && heldItemSaturation == 0.0f && !heldItemThirst) {
                RenderThirstGui.resetFlash();
            }
            int hydration = THIRST_CAP.getHydrationLevel();
            float saturation = THIRST_CAP.getSaturationLevel();
            float exhaustion = THIRST_CAP.getThirstExhaustion();
            int left = width / 2 + 91 + Config.Baked.hydrationBarOffsetX;
            int top = height - rightHeight + Config.Baked.hydrationBarOffsetY;
            boolean hasThirstEffect = player.hasEffect(MobEffectRegistry.THIRST);
            boolean hasHeatThirstEffect = player.hasEffect(MobEffectRegistry.HEAT_THIRST);
            ThirstEffect thirstEffect = ThirstEffect.getEffect(hasThirstEffect, hasHeatThirstEffect);
            ThirstEffect targetThirstEffect = ThirstEffect.getEffect(hasThirstEffect || heldItemThirst, hasHeatThirstEffect);
            if (Config.Baked.hydrationExhaustionDisplayed) {
                float exhaustionRatio = Mth.clamp((float)(exhaustion / 4.0f), (float)0.0f, (float)1.0f);
                int exhaustionBarWidth = (int)(exhaustionRatio * 81.0f);
                x = left - exhaustionBarWidth;
                y = top;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                gui.blit(ICONS, x, y, 203 - exhaustionBarWidth, 18, exhaustionBarWidth, 9);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            for (int i = 0; i < 10; ++i) {
                int halfIcon = i * 2 + 1;
                x = left - i * 8 - 9;
                y = top;
                int yOffset = 0;
                if (Config.Baked.showVanillaBarAnimationOverlay && saturation <= 0.0f && player.tickCount % (hydration * 3 + 1) == 0) {
                    yOffset = rand.nextInt(3) - 1;
                }
                if (hydration + Math.min(heldItemHydration, 0) <= halfIcon && halfIcon <= hydration + Math.max(heldItemHydration, 0)) {
                    RenderThirstGui.renderFading(gui, x, y + yOffset, new ThirstIcon(thirstEffect.getXTextureOffset(halfIcon == hydration, heldItemHydration > 0), thirstEffect.getYTextureOffset()), new ThirstIcon(targetThirstEffect.getXTextureOffset(halfIcon == hydration + heldItemHydration, heldItemHydration < 0), thirstEffect.getYTextureOffset()));
                } else {
                    gui.blit(ICONS, x, y + yOffset, thirstEffect.getXTextureOffset(false, halfIcon > hydration + Math.max(heldItemHydration, 0)), thirstEffect.getYTextureOffset(), 9, 9);
                }
                if (!Config.Baked.hydrationSaturationDisplayed) continue;
                if (Mth.ceil((float)(saturation + Math.min(heldItemSaturation, 0.0f))) <= halfIcon && halfIcon <= Mth.ceil((float)(saturation + Math.max(heldItemSaturation, 0.0f)))) {
                    if (heldItemSaturation < 0.0f || halfIcon == Mth.ceil((float)saturation)) {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaPreview));
                        gui.blit(ICONS, x, y, thirstEffect.getXTextureOffsetSaturation(halfIcon == Mth.ceil((float)saturation)), 0, 9, 9);
                    }
                    if (heldItemSaturation > 0.0f || Mth.ceil((float)(saturation + heldItemSaturation)) == halfIcon) {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPreview);
                        gui.blit(ICONS, x, y, targetThirstEffect.getXTextureOffsetSaturation(halfIcon == Mth.ceil((float)(saturation + heldItemSaturation))), 0, 9, 9);
                    }
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    continue;
                }
                if (halfIcon >= Mth.ceil((float)(saturation + Math.min(heldItemSaturation, 0.0f)))) continue;
                gui.blit(ICONS, x, y + yOffset, thirstEffect.getXTextureOffsetSaturation(false), 0, 9, 9);
            }
        }
    }

    public static void renderFading(GuiGraphics gui, int x, int y, ThirstIcon thirstIconFrom, ThirstIcon thirstIconTo) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaPreview));
        gui.blit(ICONS, x, y, thirstIconFrom.xTextureOffset, thirstIconFrom.yTextureOffset, 9, 9);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaPreview);
        gui.blit(ICONS, x, y, thirstIconTo.xTextureOffset, thirstIconTo.yTextureOffset, 9, 9);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void updateTimer() {
        if ((unclampedAlphaPreview += (float)alphaDirection * 0.125f) >= 1.5f) {
            alphaDirection = -1;
        } else if (unclampedAlphaPreview <= -0.5f) {
            alphaDirection = 1;
        }
        alphaPreview = Mth.clamp((float)unclampedAlphaPreview, (float)0.0f, (float)1.0f);
    }

    public static void resetFlash() {
        alphaPreview = 0.0f;
        unclampedAlphaPreview = 0.0f;
        alphaDirection = 1;
    }

    static {
        alphaDirection = 1;
    }

    public static enum ThirstEffect {
        NONE(0, 0, 54),
        THIRST(27, 0, 72),
        HEAT_THIRST(0, 9, 72),
        BOTH(27, 9, 126);

        private final int xTextureOffset;
        private final int yTextureOffset;
        private final int xTextureOffsetSaturation;

        private ThirstEffect(int xTextureOffset, int yTextureOffset, int xTextureOffsetSaturation) {
            this.xTextureOffset = xTextureOffset;
            this.yTextureOffset = yTextureOffset;
            this.xTextureOffsetSaturation = xTextureOffsetSaturation;
        }

        public static ThirstEffect getEffect(boolean hasThirstEffect, boolean hasHeatThirstEffect) {
            if (hasThirstEffect && hasHeatThirstEffect) {
                return BOTH;
            }
            if (hasThirstEffect) {
                return THIRST;
            }
            if (hasHeatThirstEffect) {
                return HEAT_THIRST;
            }
            return NONE;
        }

        public int getXTextureOffset(boolean isHalfIcon, boolean isContainer) {
            return isHalfIcon ? this.xTextureOffset + 18 : (isContainer ? this.xTextureOffset : this.xTextureOffset + 9);
        }

        public int getYTextureOffset() {
            return this.yTextureOffset;
        }

        public int getXTextureOffsetSaturation(boolean isHalfIcon) {
            return isHalfIcon ? this.xTextureOffsetSaturation + 9 : this.xTextureOffsetSaturation;
        }
    }

    public record ThirstIcon(int xTextureOffset, int yTextureOffset) {
    }
}

