/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.common.attachments.wetness.WetnessAttachment;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class RenderWetnessGui {
    private static final Random rand = new Random();
    private static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/overlay.png");
    private static final int WETNESS_TEXTURE_POS_Y = 96;
    private static final int WETNESS_TEXTURE_WIDTH = 10;
    private static final int WETNESS_TEXTURE_HEIGHT = 10;
    private static WetnessAttachment WETNESS_CAP = null;
    private static int frameCounter = -1;
    private static boolean startAnimation = false;
    private static WetnessIcon lastWetnessIcon;
    private static int flashCounter;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Config.Baked.wetnessEnabled && !Minecraft.getInstance().options.hideGui && (player = Minecraft.getInstance().player) != null && !player.isCreative() && !player.isSpectator()) {
            rand.setSeed((long)player.tickCount * 445L);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Minecraft.getInstance().getProfiler().push("wetness_gui");
            RenderWetnessGui.drawWetness(guiGraphics, (Player)player, width, height);
            Minecraft.getInstance().getProfiler().pop();
            RenderSystem.disableBlend();
        }
    }

    public static void drawWetness(GuiGraphics gui, Player player, int width, int height) {
        WetnessIcon wetnessIcon;
        int wetness;
        if (WETNESS_CAP == null || player.tickCount % 20 == 0) {
            WETNESS_CAP = AttachmentUtil.getWetnessAttachment(player);
        }
        if ((wetness = WETNESS_CAP.getWetness()) == 0) {
            return;
        }
        int x = width / 2 - 5 + Config.Baked.wetnessIndicatorOffsetX;
        int y = height - 61 + Config.Baked.wetnessIndicatorOffsetY;
        if (CuriosUtil.isThermometerEquipped && Config.Baked.wetnessIndicatorOffsetY == 0) {
            y += 10;
        }
        if (lastWetnessIcon != (wetnessIcon = WetnessIcon.get(wetness))) {
            flashCounter = 3;
            lastWetnessIcon = wetnessIcon;
        }
        gui.blit(ICONS, x, y, wetnessIcon.getXTextureOffset(), wetnessIcon.getYTextureOffset(flashCounter >= 0), 10, 10);
    }

    public static void updateTimer() {
        if (frameCounter >= 0) {
            --frameCounter;
        }
        if (flashCounter >= 0) {
            --flashCounter;
        }
        if (startAnimation) {
            frameCounter = 24;
            startAnimation = false;
        }
    }

    static {
        flashCounter = -1;
    }

    private static enum WetnessIcon {
        WETNESS_0(0),
        WETNESS_1(1),
        WETNESS_2(2),
        WETNESS_3(3);

        public final int iconIndexX;

        private WetnessIcon(int iconIndexX) {
            this.iconIndexX = iconIndexX;
        }

        public static WetnessIcon get(int wetness) {
            float wetnessRation = (float)wetness / 400.0f;
            if (wetnessRation <= 0.25f) {
                return WETNESS_0;
            }
            if (wetnessRation <= 0.5f) {
                return WETNESS_1;
            }
            if (wetnessRation <= 0.75f) {
                return WETNESS_2;
            }
            return WETNESS_3;
        }

        public int getXTextureOffset() {
            return this.iconIndexX * 10;
        }

        public int getYTextureOffset(boolean isFlash) {
            return 96 + (isFlash ? 10 : 0);
        }
    }
}

