/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.containers.AbstractThermalContainer;

@OnlyIn(value=Dist.CLIENT)
public class ThermalScreen
extends AbstractContainerScreen<AbstractThermalContainer> {
    public static final ResourceLocation HEATER_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/heater_screen.png");
    public static final ResourceLocation COOLER_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/cooler_screen.png");
    public static final int FUEL_LEVEL_WIDTH = 29;
    public static final int FUEL_LEVEL_HEIGHT = 27;

    public ThermalScreen(AbstractThermalContainer screenContainer, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, playerInventory, titleIn);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int x, int y) {
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation TEXTURE = ((AbstractThermalContainer)this.menu).getThermalType() == ThermalTypeEnum.HEATING ? HEATER_SCREEN : COOLER_SCREEN;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        gui.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int fuelTimeHeight = (int)(((AbstractThermalContainer)this.menu).getFuelTimeScale() * 27.0f);
        gui.blit(TEXTURE, this.leftPos + 73, this.topPos + 35 + (27 - fuelTimeHeight), 176, 24 + (27 - fuelTimeHeight), 29, fuelTimeHeight);
        if (((AbstractThermalContainer)this.menu).isPowered()) {
            gui.blit(TEXTURE, this.leftPos + 137, this.topPos + 37, 176, 0, 12, 24);
        }
    }
}

