/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.shaders;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FocusShader {
    public static final ResourceLocation BLOBS2_SHADER = ResourceLocation.parse((String)"shaders/post/blobs2.json");
    public static final ResourceLocation BLUR_SHADER = ResourceLocation.parse((String)"shaders/post/blur.json");
    private static boolean shaderLoadAttempted = false;
    private static boolean shaderAvailable = false;
    private static String loadedShaderName = null;

    public void render(float intensity) {
        if (intensity <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PostChain effect = mc.gameRenderer.currentEffect();
        if (!shaderLoadAttempted) {
            shaderLoadAttempted = true;
            try {
                mc.gameRenderer.loadEffect(BLOBS2_SHADER);
                effect = mc.gameRenderer.currentEffect();
                shaderAvailable = effect != null;
                loadedShaderName = shaderAvailable ? effect.getName() : null;
            }
            catch (Throwable t) {
                try {
                    mc.gameRenderer.loadEffect(BLUR_SHADER);
                    effect = mc.gameRenderer.currentEffect();
                    shaderAvailable = effect != null;
                    loadedShaderName = shaderAvailable ? effect.getName() : null;
                }
                catch (Throwable ignored) {
                    shaderAvailable = false;
                }
            }
        }
        if (!shaderAvailable) {
            return;
        }
        if (effect == null || loadedShaderName != null && !effect.getName().equals(loadedShaderName)) {
            return;
        }
        this.updateIntensity(intensity);
    }

    public void stopRender() {
        Minecraft mc = Minecraft.getInstance();
        PostChain effect = mc.gameRenderer.currentEffect();
        if (effect != null) {
            mc.gameRenderer.shutdownEffect();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateIntensity(float intensity) {
        PostChain effect = Minecraft.getInstance().gameRenderer.currentEffect();
        if (effect != null) {
            effect.setUniform("Radius", intensity);
        }
    }
}

