/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.tooltips;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonMobEffect;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.item.CoatEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.client.tooltips.HydrationTooltipComponent;
import sfiomn.legendarysurvivaloverhaul.common.integration.artifacts.ArtifactsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.beachparty.BeachpartyUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

@EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class TooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (!stack.isEmpty() && itemRegistryName != null) {
            List tooltips = event.getToolTip();
            for (Component component : tooltips) {
                if (!(component instanceof MutableComponent)) continue;
                MutableComponent mutableComponent = (MutableComponent)component;
                if (TooltipHandler.componentHasOneOfKeys(component, ((Attribute)AttributeRegistry.HEATING_TEMPERATURE.get()).getDescriptionId(), ((Attribute)AttributeRegistry.HEAT_RESISTANCE.get()).getDescriptionId())) {
                    mutableComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16420407)));
                }
                if (TooltipHandler.componentHasOneOfKeys(component, ((Attribute)AttributeRegistry.COOLING_TEMPERATURE.get()).getDescriptionId(), ((Attribute)AttributeRegistry.COLD_RESISTANCE.get()).getDescriptionId())) {
                    mutableComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6466303)));
                }
                if (!TooltipHandler.componentHasOneOfKeys(component, ((Attribute)AttributeRegistry.THERMAL_RESISTANCE.get()).getDescriptionId())) continue;
                mutableComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x9933FF)));
            }
            if (Config.Baked.temperatureEnabled) {
                if (stack.getItem() instanceof ArmorItem) {
                    TooltipHandler.addCoatTemperatureOnArmorText(stack, tooltips);
                }
                TooltipHandler.addFoodEffectText(stack, tooltips);
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                TooltipHandler.addHealingText(stack, tooltips);
            }
            if (LegendarySurvivalOverhaul.beachpartyLoaded) {
                TooltipHandler.addShadeText(stack, tooltips);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Screen gui = mc.screen;
        if (gui == null) {
            return;
        }
        if (Config.Baked.thirstEnabled && Config.Baked.showHydrationTooltip) {
            TooltipHandler.addHydrationTooltip(event.getItemStack(), event.getTooltipElements());
        }
    }

    private static boolean componentHasOneOfKeys(Component component, String ... keys) {
        TranslatableContents translatableContents;
        ComponentContents componentContents;
        if (component != null && (componentContents = component.getContents()) instanceof TranslatableContents && (translatableContents = (TranslatableContents)componentContents).getArgs() != null) {
            return Arrays.stream(translatableContents.getArgs()).anyMatch(s -> {
                MutableComponent mutableComponent;
                ComponentContents patt0$temp;
                if (s instanceof MutableComponent && (patt0$temp = (mutableComponent = (MutableComponent)s).getContents()) instanceof TranslatableContents) {
                    TranslatableContents translatableContents1 = (TranslatableContents)patt0$temp;
                    for (String key : keys) {
                        if (!translatableContents1.getKey().equals(key)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            });
        }
        return false;
    }

    private static void addCoatTemperatureOnArmorText(ItemStack stack, List<Component> tooltips) {
        String coatId = TemperatureUtil.getArmorCoatTag(stack);
        CoatEnum coat = CoatEnum.getFromId(coatId);
        if (coat == null) {
            return;
        }
        MutableComponent text = Component.translatable((String)("tooltip.legendarysurvivaloverhaul.armor_coat." + coatId));
        text = Component.literal((String)"").withStyle(ChatFormatting.BLUE).append((Component)text);
        tooltips.add((Component)text);
    }

    private static void addFoodEffectText(ItemStack stack, List<Component> tooltips) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        List<JsonTemperatureConsumable> jtcs = TemperatureDataManager.getConsumable(itemRegistryName);
        if (jtcs != null) {
            for (JsonTemperatureConsumable jtc : jtcs) {
                MobEffectInstance effectInstance = new MobEffectInstance(Holder.direct((Object)jtc.getEffect()), jtc.duration, Math.abs(jtc.temperatureLevel));
                MutableComponent mutableComponent = Component.translatable((String)effectInstance.getDescriptionId());
                if (Math.abs(jtc.temperatureLevel) > 1) {
                    mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + (Math.abs(jtc.temperatureLevel) - 1)))});
                }
                if (jtc.duration > 20) {
                    mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)20.0f)});
                }
                if (jtc.getEffect() == MobEffectRegistry.COLD_FOOD.get() || jtc.getEffect() == MobEffectRegistry.COLD_DRINK.get()) {
                    tooltips.add((Component)mutableComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6466303))));
                }
                if (jtc.getEffect() != MobEffectRegistry.HOT_FOOD.get()) continue;
                tooltips.add((Component)mutableComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16420407))));
            }
        }
    }

    private static void addHealingText(ItemStack stack, List<Component> tooltips) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        JsonHealingConsumable jsonConsumableHeal = BodyDamageDataManager.getHealingItem(itemRegistryName);
        if (jsonConsumableHeal != null) {
            if (jsonConsumableHeal.healingCharges > 0) {
                tooltips.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.body_heal_item.body_part", (Object[])new Object[]{jsonConsumableHeal.healingCharges}).withStyle(ChatFormatting.BLUE));
            } else if (jsonConsumableHeal.healingCharges == 0) {
                tooltips.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.body_heal_item.whole_body").withStyle(ChatFormatting.BLUE));
            }
            tooltips.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.body_heal_item.healing_value", (Object[])new Object[]{Float.valueOf(jsonConsumableHeal.healingValue), Float.valueOf(MathUtil.round((float)jsonConsumableHeal.healingTime / 20.0f, 1))}).withStyle(ChatFormatting.BLUE));
            MutableComponent mutableComponent = Component.translatable((String)((MobEffect)MobEffectRegistry.RECOVERY.get()).getDescriptionId());
            if (jsonConsumableHeal.recoveryEffectDuration > 0) {
                if (jsonConsumableHeal.recoveryEffectAmplifier > 0) {
                    mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + jsonConsumableHeal.recoveryEffectAmplifier))});
                }
                MobEffectInstance mei = new MobEffectInstance(MobEffectRegistry.RECOVERY, jsonConsumableHeal.recoveryEffectDuration, jsonConsumableHeal.recoveryEffectAmplifier);
                mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)mei, (float)1.0f, (float)20.0f)});
                tooltips.add((Component)mutableComponent.withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
            }
        }
    }

    private static void addShadeText(ItemStack stack, List<Component> tooltips) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (itemRegistryName != null && (BeachpartyUtil.canProvideShade(itemRegistryName) || ArtifactsUtil.canProvideShade(itemRegistryName))) {
            tooltips.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.provides_shade").withStyle(ChatFormatting.WHITE));
        }
    }

    private static void addHydrationTooltip(ItemStack stack, List<Either<FormattedText, TooltipComponent>> tooltips) {
        JsonThirstConsumable jsonThirstConsumable = ThirstDataManager.getConsumable(stack);
        HydrationTooltipComponent hydrationTooltipComponent = null;
        ArrayList<MutableComponent> hydrationEffectComponents = new ArrayList<MutableComponent>();
        if (jsonThirstConsumable != null) {
            hydrationTooltipComponent = new HydrationTooltipComponent(jsonThirstConsumable.hydration, jsonThirstConsumable.saturation);
            for (JsonMobEffect effect : jsonThirstConsumable.effects) {
                if (!(effect.chance > 0.0f) || effect.duration <= 0 || effect.name.isEmpty()) continue;
                hydrationEffectComponents.add(TooltipHandler.getHydrationEffectTooltip(effect.chance, effect.name, effect.amplifier, effect.duration));
            }
        }
        if (hydrationTooltipComponent != null) {
            tooltips.add((Either<FormattedText, TooltipComponent>)Either.right(hydrationTooltipComponent));
        }
        for (MutableComponent hydrationEffectComponent : hydrationEffectComponents) {
            if (hydrationEffectComponent == null) continue;
            tooltips.add((Either<FormattedText, TooltipComponent>)Either.left((Object)hydrationEffectComponent));
        }
    }

    private static MutableComponent getHydrationEffectTooltip(double effectChance, String effectName, int amplifier, int duration) {
        MobEffect effect = null;
        if (effectName != null && !effectName.isEmpty() && effectChance > 0.0) {
            effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)effectName));
        }
        if (effect == null) {
            return null;
        }
        MobEffectInstance effectInstance = new MobEffectInstance(Holder.direct(effect), duration, amplifier, false, true);
        MutableComponent mutableComponent = Component.translatable((String)effectInstance.getDescriptionId());
        if (effectInstance.getAmplifier() > 1) {
            mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + effectInstance.getAmplifier()))});
        }
        if (effectInstance.getDuration() > 20) {
            mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)20.0f)});
        }
        if (effectChance < 1.0) {
            mutableComponent = Component.translatable((String)"tooltip.legendarysurvivaloverhaul.potion_with_effectChance", (Object[])new Object[]{(int)(effectChance * 100.0), mutableComponent});
        }
        return mutableComponent.withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
    }
}

