/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.attachments.health;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sfiomn.legendarysurvivaloverhaul.api.health.IHealthAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class HealthAttachment
implements IHealthAttachment,
INBTSerializable<CompoundTag> {
    private float additionalHealth;
    private float shieldHealth;
    private float oldAdditionalHealth;
    private float oldShieldHealth;
    private int packetTimer;

    public HealthAttachment() {
        this.init();
    }

    public void init() {
        this.additionalHealth = 0.0f;
        this.shieldHealth = 0.0f;
        this.oldAdditionalHealth = 0.0f;
        this.oldShieldHealth = 0.0f;
        this.packetTimer = 0;
    }

    @Override
    public void addAdditionalHealth(float healthValue) {
        this.setAdditionalHealth(this.getAdditionalHealth() + healthValue);
    }

    @Override
    public void addShieldHealth(float shieldValue) {
        this.setShieldHealth(this.getShieldHealth() + shieldValue);
    }

    @Override
    public float getAdditionalHealth() {
        return this.additionalHealth;
    }

    @Override
    public void setAdditionalHealth(float newHealthValue) {
        this.additionalHealth = Math.min(newHealthValue, (float)Config.Baked.maxAdditionalHealth);
    }

    @Override
    public float getShieldHealth() {
        return this.shieldHealth;
    }

    @Override
    public void setShieldHealth(float newHealthValue) {
        this.shieldHealth = Mth.clamp((float)newHealthValue, (float)0.0f, (float)((float)Config.Baked.maxShieldHealth));
    }

    @Override
    public boolean isDirty() {
        return this.additionalHealth != this.oldAdditionalHealth || this.shieldHealth != this.oldShieldHealth;
    }

    @Override
    public void setClean() {
        this.oldAdditionalHealth = this.additionalHealth;
        this.oldShieldHealth = this.shieldHealth;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putFloat("additionalHealth", this.getAdditionalHealth());
        compound.putFloat("shieldHealth", this.getShieldHealth());
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        if (compound.contains("additionalHealth")) {
            this.setAdditionalHealth(compound.getFloat("additionalHealth"));
        }
        if (compound.contains("shieldHealth")) {
            this.setShieldHealth(compound.getFloat("shieldHealth"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeNBT();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readNBT(nbt);
    }
}

