/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.attachments.temperature;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ITemperatureItemAttachment;
import sfiomn.legendarysurvivaloverhaul.registry.DataComponentRegistry;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class TemperatureItemAttachment
implements ITemperatureItemAttachment,
INBTSerializable<CompoundTag> {
    private final ItemStack itemStack;

    public TemperatureItemAttachment(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public TemperatureItemAttachment() {
        this.itemStack = ItemStack.EMPTY;
    }

    private DataComponentRegistry.TemperatureData getData() {
        if (this.itemStack.isEmpty()) {
            return new DataComponentRegistry.TemperatureData();
        }
        DataComponentRegistry.TemperatureData data = (DataComponentRegistry.TemperatureData)this.itemStack.get((DataComponentType)DataComponentRegistry.TEMPERATURE_DATA.get());
        return data != null ? data : new DataComponentRegistry.TemperatureData();
    }

    private void setData(DataComponentRegistry.TemperatureData data) {
        if (!this.itemStack.isEmpty()) {
            this.itemStack.set((DataComponentType)DataComponentRegistry.TEMPERATURE_DATA.get(), (Object)data);
        }
    }

    @Override
    public boolean shouldUpdate(long currentTick) {
        return this.getData().shouldUpdate(currentTick);
    }

    @Override
    public void updateWorldTemperature(Level world, Entity holder, long currentTick) {
        float newTemperature = WorldUtil.calculateClientWorldEntityTemperature(world, holder);
        this.setData(new DataComponentRegistry.TemperatureData(newTemperature, currentTick));
    }

    @Override
    public float getWorldTemperatureLevel() {
        return this.getData().temperature();
    }

    @Override
    public void setWorldTemperatureLevel(float temperature) {
        DataComponentRegistry.TemperatureData current = this.getData();
        this.setData(current.withTemperature(temperature));
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("temperature", this.getWorldTemperatureLevel());
        return tag;
    }

    public void readNBT(CompoundTag tag) {
        if (tag.contains("temperature")) {
            this.setWorldTemperatureLevel(tag.getFloat("temperature"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeNBT();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readNBT(nbt);
    }
}

