/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.attachments.thirst;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sfiomn.legendarysurvivaloverhaul.api.ModDamageTypes;
import sfiomn.legendarysurvivaloverhaul.api.thirst.IThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.DifficultyUtil;

public class ThirstAttachment
implements IThirstAttachment,
INBTSerializable<CompoundTag> {
    public static int MAX_HYDRATION = 20;
    public static float MAX_SATURATION = 20.0f;
    private float exhaustion = 0.0f;
    private int thirst;
    private float saturation;
    private int tickTimer;
    private int damageTickTimer;
    private int damageCounter;
    private int oldHydration;
    private float oldSaturation;
    private float oldExhaustion;
    private boolean wasSprinting;
    private Vec3 oldPos;
    private boolean dirty;
    private int packetTimer;

    public ThirstAttachment() {
        this.init();
    }

    public void init() {
        this.thirst = 20;
        this.saturation = 5.0f;
        this.tickTimer = 0;
        this.damageCounter = 0;
        this.oldHydration = 0;
        this.oldSaturation = 0.0f;
        this.oldExhaustion = 0.0f;
        this.wasSprinting = false;
        this.oldPos = null;
        this.dirty = false;
        this.damageTickTimer = 0;
        this.packetTimer = 0;
    }

    @Override
    public void tickUpdate(Player player, Level level, boolean isStart) {
        if (this.getTickTimer() == -1) {
            return;
        }
        if (isStart) {
            ++this.packetTimer;
            return;
        }
        if (this.oldPos == null) {
            this.oldPos = player.position();
        }
        this.addTickTimer(1);
        if (this.getTickTimer() >= 10) {
            this.setTickTimer(0);
            if (player.hasEffect(MobEffectRegistry.HYDRATION_FILL)) {
                if (this.getHydrationLevel() < MAX_HYDRATION) {
                    this.addHydrationLevel(1);
                }
                return;
            }
            if (this.oldPos.distanceTo(player.position()) > 1.0) {
                float thirstExhausted = player.isSprinting() && this.wasSprinting ? (float)Config.Baked.sprintingHydrationExhaustion : (player.isSprinting() || this.wasSprinting ? (float)((Config.Baked.sprintingHydrationExhaustion + Config.Baked.baseHydrationExhaustion) / 2.0) : (float)Config.Baked.baseHydrationExhaustion);
                this.addThirstExhaustion(thirstExhausted);
                this.oldPos = player.position();
                this.wasSprinting = player.isSprinting();
            }
        }
        if (this.getThirstExhaustion() > 4.0f) {
            this.addThirstExhaustion(-4.0f);
            if (this.getSaturationLevel() > 0.0f) {
                this.addSaturationLevel(-1.0f);
            } else if (DifficultyUtil.isModDangerous()) {
                this.addHydrationLevel(-1);
            }
        }
        if (this.getHydrationLevel() <= 0) {
            this.addThirstDamageTickTimer(1);
            if (this.getThirstDamageTickTimer() > 80) {
                this.setThirstDamageTickTimer(0);
                if (DifficultyUtil.isModDangerous() && DifficultyUtil.healthAboveDifficulty(player) && !player.isSpectator() && !player.isCreative() && Config.Baked.dangerousDehydration) {
                    this.applyDangerousEffect(player);
                }
            }
        } else {
            this.setThirstDamageTickTimer(0);
            this.setThirstDamageCounter(0);
        }
    }

    private void applyDangerousEffect(Player player) {
        this.addThirstDamageCounter(1);
        float thirstDamageToApply = (float)((double)this.getThirstDamageCounter() * Config.Baked.dehydrationDamageScaling);
        ModDamageTypes.dehydration((Entity)player, thirstDamageToApply);
    }

    @Override
    public boolean isDirty() {
        return this.thirst != this.oldHydration || this.saturation != this.oldSaturation || this.exhaustion != this.oldExhaustion || this.dirty;
    }

    @Override
    public void setClean() {
        this.oldHydration = this.thirst;
        this.oldSaturation = this.saturation;
        this.oldExhaustion = this.exhaustion;
        this.dirty = false;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public float getThirstExhaustion() {
        return this.exhaustion;
    }

    public void setThirstExhaustion(float exhaustion) {
        this.setExhaustion(exhaustion);
    }

    @Override
    public int getHydrationLevel() {
        return this.thirst;
    }

    @Override
    public void setHydrationLevel(int thirst) {
        this.thirst = Mth.clamp((int)thirst, (int)0, (int)MAX_HYDRATION);
    }

    @Override
    public float getSaturationLevel() {
        return this.saturation;
    }

    @Override
    public int getTickTimer() {
        return this.tickTimer;
    }

    @Override
    public void setTickTimer(int ticktimer) {
        this.tickTimer = ticktimer;
    }

    public void setThirstTickTimer(int ticktimer) {
        this.setTickTimer(ticktimer);
    }

    @Override
    public int getThirstDamageTickTimer() {
        return this.damageTickTimer;
    }

    @Override
    public void setThirstDamageTickTimer(int damageTickTimer) {
        this.damageTickTimer = damageTickTimer;
    }

    @Override
    public int getThirstDamageCounter() {
        return this.damageCounter;
    }

    @Override
    public void setThirstDamageCounter(int damageCounter) {
        this.damageCounter = damageCounter;
    }

    @Override
    public void setExhaustion(float exhaustion) {
        this.exhaustion = Math.max(exhaustion, 0.0f);
        if (!Float.isFinite(this.exhaustion)) {
            this.exhaustion = 0.0f;
        }
    }

    @Override
    public void setSaturation(float saturation) {
        this.saturation = Mth.clamp((float)saturation, (float)0.0f, (float)MAX_SATURATION);
        if (!Float.isFinite(this.saturation)) {
            this.saturation = 0.0f;
        }
    }

    public void setThirstSaturation(float saturation) {
        this.setSaturation(saturation);
    }

    @Override
    public void addThirstExhaustion(float exhaustion) {
        this.setExhaustion(this.getThirstExhaustion() + exhaustion);
    }

    @Override
    public void addHydrationLevel(int thirst) {
        this.setHydrationLevel(this.getHydrationLevel() + thirst);
    }

    @Override
    public void addSaturationLevel(float saturation) {
        this.setSaturation(Math.max((float)Math.round((this.getSaturationLevel() + saturation) * 100.0f) / 100.0f, 0.0f));
    }

    @Override
    public void addTickTimer(int ticktimer) {
        this.setTickTimer(this.getTickTimer() + ticktimer);
    }

    public void addThirstTickTimer(int ticktimer) {
        this.addTickTimer(ticktimer);
    }

    @Override
    public void addThirstDamageTickTimer(int damageTickTimer) {
        this.setThirstDamageTickTimer(this.getThirstDamageTickTimer() + damageTickTimer);
    }

    @Override
    public void addThirstDamageCounter(int damageCounter) {
        this.setThirstDamageCounter(this.getThirstDamageCounter() + damageCounter);
    }

    @Override
    public boolean isHydrationLevelAtMax() {
        return this.getHydrationLevel() >= MAX_HYDRATION;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putFloat("exhaustion", this.getThirstExhaustion());
        compound.putInt("hydrationLevel", this.getHydrationLevel());
        compound.putFloat("saturation", this.getSaturationLevel());
        compound.putInt("tickTimer", this.getTickTimer());
        compound.putInt("thirstDamageTickTimer", this.getThirstDamageTickTimer());
        compound.putInt("thirstDamageCounter", this.getThirstDamageCounter());
        return compound;
    }

    public void readNBT(CompoundTag nbt) {
        this.init();
        if (nbt.contains("exhaustion")) {
            this.setExhaustion(nbt.getFloat("exhaustion"));
        }
        if (nbt.contains("hydrationLevel")) {
            this.setHydrationLevel(nbt.getInt("hydrationLevel"));
        }
        if (nbt.contains("saturation")) {
            this.setSaturation(nbt.getFloat("saturation"));
        }
        if (nbt.contains("tickTimer")) {
            this.setTickTimer(nbt.getInt("tickTimer"));
        }
        if (nbt.contains("thirstDamageTickTimer")) {
            this.setThirstDamageTickTimer(nbt.getInt("thirstDamageTickTimer"));
        }
        if (nbt.contains("thirstDamageCounter")) {
            this.setThirstDamageCounter(nbt.getInt("thirstDamageCounter"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeNBT();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readNBT(nbt);
    }
}

