/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.attachments.wetness;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sfiomn.legendarysurvivaloverhaul.api.wetness.IWetnessAttachment;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.meadow.MeadowUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class WetnessAttachment
implements IWetnessAttachment,
INBTSerializable<CompoundTag> {
    public static final int WETNESS_LIMIT = 400;
    private int wetness;
    private int wetnessTickTimer;
    private int packetTimer;
    private int oldWetness;
    private boolean dirty = false;

    public WetnessAttachment() {
        this.init();
    }

    public void init() {
        this.wetness = 0;
        this.wetnessTickTimer = 0;
        this.packetTimer = 0;
        this.oldWetness = this.wetness;
        this.dirty = false;
    }

    @Override
    public int getWetness() {
        return this.wetness;
    }

    @Override
    public void setWetness(int wetness) {
        this.wetness = Mth.clamp((int)wetness, (int)0, (int)400);
    }

    @Override
    public int getWetnessTickTimer() {
        return this.wetnessTickTimer;
    }

    @Override
    public void setWetnessTickTimer(int tickTimer) {
        this.wetnessTickTimer = tickTimer;
    }

    @Override
    public void addWetness(int wetness) {
        this.setWetness(this.wetness + wetness);
    }

    @Override
    public void addWetnessTickTimer(int tickTimer) {
        this.setWetnessTickTimer(this.getWetnessTickTimer() + tickTimer);
    }

    @Override
    public void tickUpdate(Player player, Level level, boolean isStart) {
        ResourceLocation entityRegistryName;
        if (this.getWetnessTickTimer() == -1 || CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.SPONGE.get())) {
            if (this.getWetness() > 0) {
                this.setWetness(0);
            }
            return;
        }
        if (isStart) {
            ++this.packetTimer;
            return;
        }
        this.addWetnessTickTimer(1);
        if (this.getWetnessTickTimer() < Config.Baked.wetnessTickTimer) {
            return;
        }
        this.setWetnessTickTimer(0);
        if (this.wetness > 0 && player.getRemainingFireTicks() > 0 && !player.fireImmune()) {
            this.addWetness(-10);
        }
        BlockPos pos = player.blockPosition();
        if (player.getVehicle() != null && (entityRegistryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)player.getVehicle().getType())) != null && Config.Baked.wetnessImmunityMounts.contains(entityRegistryName.toString())) {
            if (this.wetness > 0) {
                this.addWetness(Config.Baked.wetnessDecrease);
            }
            return;
        }
        if (player.getVehicle() != null && !(player.getVehicle() instanceof LivingEntity) && !player.getVehicle().hasImpulse) {
            pos = pos.above();
            if (this.wetness > 0 && level.getFluidState(pos).isEmpty()) {
                this.worldParticles(player, level);
            }
        } else if (this.wetness > 0 && (level.getFluidState(pos).isEmpty() || level.getFluidState(pos.above()).isEmpty())) {
            this.worldParticles(player, level);
        }
        FluidState fluidState = level.getFluidState(pos);
        BlockState blockState = level.getBlockState(pos);
        FluidState fluidStateUp = level.getFluidState(pos.above());
        if (fluidState.isEmpty() && !blockState.is(Blocks.WATER_CAULDRON) && !MeadowUtil.isInWoodenWaterCauldron(blockState)) {
            Biome.Precipitation precipitation = WorldUtil.getPrecipitationAt(level, player, pos);
            if (this.wetness < 400 && precipitation == Biome.Precipitation.RAIN) {
                this.addWetness(Config.Baked.wetnessRainIncrease);
            } else if (this.wetness > 0 && precipitation == Biome.Precipitation.NONE) {
                this.addWetness(Config.Baked.wetnessDecrease);
            }
        } else {
            Fluid fluid = Fluids.EMPTY;
            float fractionalLevel = 0.0f;
            if (!fluidState.isEmpty()) {
                fluid = fluidState.getType();
                fractionalLevel = MathUtil.invLerp(1.0f, 8.0f, fluidState.getAmount());
            } else if (blockState.is(Blocks.WATER_CAULDRON) || MeadowUtil.isInWoodenWaterCauldron(blockState)) {
                fluid = Fluids.WATER;
                if (blockState.hasProperty((Property)LayeredCauldronBlock.LEVEL)) {
                    fractionalLevel = MathUtil.invLerp(1.0f, 3.0f, ((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue());
                }
            }
            if ((float)player.position().y() > (float)pos.getY() + fractionalLevel + 0.0625f) {
                return;
            }
            if (!fluidStateUp.isEmpty()) {
                fractionalLevel += MathUtil.invLerp(1.0f, 8.0f, fluidStateUp.getAmount());
            }
            if (this.wetness > 0 && fluid instanceof LavaFluid) {
                this.addWetness(-Math.round(20.0f * fractionalLevel));
            } else if (this.wetness < 400) {
                this.addWetness(Math.round((float)Config.Baked.wetnessFluidIncrease * fractionalLevel));
            }
        }
    }

    private void worldParticles(Player player, Level level) {
        Vec3 pos = player.position();
        AABB box = player.getBoundingBox();
        int particleSpawnRate = Math.round((1.0f - MathUtil.invLerp(0.0f, 400.0f, this.wetness)) * 10.0f);
        if (particleSpawnRate == 0 || level.getLevelData().getGameTime() % (long)particleSpawnRate == 0L) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.FALLING_WATER, pos.x, pos.y + box.getYsize() / 2.0, pos.z, 1, box.getXsize() / 3.0, box.getYsize() / 4.0, box.getZsize() / 3.0, 0.0);
        }
    }

    @Override
    public boolean isDirty() {
        return this.wetness != this.oldWetness || this.dirty;
    }

    @Override
    public void setClean() {
        this.oldWetness = this.wetness;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putInt("wetness", this.getWetness());
        compound.putInt("wetnessTickTimer", this.getWetnessTickTimer());
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        if (compound.contains("wetness")) {
            this.setWetness(compound.getInt("wetness"));
        }
        if (compound.contains("wetnessTickTimer")) {
            this.setWetnessTickTimer(compound.getInt("wetnessTickTimer"));
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeNBT();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readNBT(nbt);
    }
}

