/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blockentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureFuelItem;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.common.blocks.ThermalBlock;

public abstract class AbstractThermalBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    public static final int SLOT_COUNT = 4;
    protected final ContainerData dataAccess;
    private final ThermalTypeEnum thermalType;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private int fuelTime = 0;
    private int fuelDuration;
    private int tickCount = 0;

    public AbstractThermalBlockEntity(BlockEntityType<?> blockEntityType, ThermalTypeEnum thermalType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.thermalType = thermalType;
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> AbstractThermalBlockEntity.this.fuelTime;
                    case 1 -> AbstractThermalBlockEntity.this.fuelDuration;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractThermalBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 1: {
                        AbstractThermalBlockEntity.this.fuelDuration = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractThermalBlockEntity entity) {
        if (level == null) {
            return;
        }
        if (!entity.isPowered()) {
            if (((Boolean)state.getValue((Property)ThermalBlock.LIT)).booleanValue() && !level.isClientSide) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(false)));
                entity.setChanged();
            }
            return;
        }
        if (entity.isLit() && !((Boolean)state.getValue((Property)ThermalBlock.LIT)).booleanValue() && !level.isClientSide) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit())));
            entity.setChanged();
        }
        if (entity.tickCount > 20) {
            entity.tickCount = 0;
            boolean initiallyLit = entity.isLit();
            boolean needRefresh = false;
            if (entity.isLit()) {
                entity.consumeFuel();
            }
            if (!entity.isLit() && !level.isClientSide) {
                entity.refillFuel();
                if (entity.isLit()) {
                    level.sendBlockUpdated(pos, state, state, 2);
                    needRefresh = true;
                }
            }
            if (initiallyLit != entity.isLit() && !level.isClientSide) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit())));
                needRefresh = true;
            }
            if (needRefresh) {
                entity.setChanged();
            }
        }
        ++entity.tickCount;
    }

    @NotNull
    public abstract Component getDefaultName();

    @NotNull
    public abstract AbstractContainerMenu createMenu(int var1, @NotNull Inventory var2);

    private void consumeFuel() {
        this.fuelTime -= 20;
    }

    public void refillFuel() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            int fuelValue;
            if (this.getItem(i).getCount() <= 0 || !this.isItemValid(this.getItem(i).getItem()) || (fuelValue = this.getFuelDuration((ItemStack)this.items.get(i))) <= 0) continue;
            this.fuelTime = fuelValue;
            this.fuelDuration = fuelValue;
            this.getItem(i).shrink(1);
            return;
        }
    }

    public boolean isItemValid(Item item) {
        ResourceLocation registryNameItem = BuiltInRegistries.ITEM.getKey((Object)item);
        JsonTemperatureFuelItem fuelInfo = TemperatureDataManager.getFuelItem(registryNameItem);
        return fuelInfo != null && fuelInfo.thermalType == this.thermalType && fuelInfo.duration > 0;
    }

    public int getFuelDuration(ItemStack item) {
        ResourceLocation registryNameItem = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        JsonTemperatureFuelItem fuelInfo = TemperatureDataManager.getFuelItem(registryNameItem);
        return fuelInfo != null ? fuelInfo.duration : 0;
    }

    public boolean isLit() {
        if (this.level != null) {
            return this.fuelTime > 0;
        }
        return false;
    }

    public boolean isPowered() {
        if (this.level != null) {
            return this.level.hasNeighborSignal(this.worldPosition);
        }
        return false;
    }

    public void fillStackedContents(@NotNull StackedContents p_58342_) {
        for (ItemStack itemstack : this.items) {
            p_58342_.accountStack(itemstack);
        }
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return this.isItemValid(itemStack.getItem());
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(slot, itemStack);
    }

    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        return slot < 4;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Nonnull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        this.fuelTime = tag.getInt("fuelTime");
        this.fuelDuration = tag.getInt("fuelDuration");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("fuelTime", this.fuelTime);
        tag.putInt("fuelDuration", this.fuelDuration);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }
}

