/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.blockentities.AbstractThermalBlockEntity;
import sfiomn.legendarysurvivaloverhaul.common.blocks.ThermalBlock;
import sfiomn.legendarysurvivaloverhaul.registry.BlockEntityRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public class CoolerBlock
extends ThermalBlock {
    public static final BlockBehaviour.Properties properties = CoolerBlock.getProperties();

    public CoolerBlock(ThermalTypeEnum thermalType) {
        super(thermalType, properties);
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 10.0f).noOcclusion();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153213_, BlockEntityType<T> entityType) {
        return level.isClientSide ? null : CoolerBlock.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.COOLER_BLOCK_ENTITY.get()), AbstractThermalBlockEntity::serverTick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            float chanceSound = 0.1f;
            float chanceParticle = 0.25f;
            double posX = pos.getX();
            double posY = pos.getY();
            double posZ = pos.getZ();
            if (rand.nextFloat() < chanceSound) {
                level.playLocalSound(posX + 0.5, posY + 0.5, posZ + 0.5, (SoundEvent)SoundRegistry.COOLER_BLOCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (rand.nextFloat() < chanceParticle) {
                float xr = rand.nextFloat();
                float zr = rand.nextFloat();
                level.addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, false, posX + (double)xr, posY + 1.0, posZ + (double)zr, 0.0, 0.0, 0.0);
            }
        }
        super.animateTick(state, level, pos, rand);
    }
}

