/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.blockentities.AbstractThermalBlockEntity;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterTopBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.ThermalBlock;
import sfiomn.legendarysurvivaloverhaul.registry.BlockEntityRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;

public class HeaterBaseBlock
extends ThermalBlock {
    public static final BlockBehaviour.Properties properties = HeaterBaseBlock.getProperties();
    private static final VoxelShape FEET = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape BASE = Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape XZ_AXIS_AABB = Shapes.or((VoxelShape)FEET, (VoxelShape)BASE);

    public HeaterBaseBlock(ThermalTypeEnum thermalType) {
        super(thermalType, properties);
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 10.0f).noOcclusion().lightLevel(lightLevel -> (Boolean)lightLevel.getValue((Property)BlockStateProperties.LIT) != false ? 13 : 0);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return XZ_AXIS_AABB;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState p_153213_, BlockEntityType<T> entityType) {
        return level.isClientSide ? null : HeaterBaseBlock.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.HEATER_BLOCK_ENTITY.get()), AbstractThermalBlockEntity::serverTick);
    }

    public ItemInteractionResult onTopUseItem(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos topPos;
        Level level = context.getLevel();
        return level.getBlockState(topPos = context.getClickedPos().above()).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(topPos) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection()) : null;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!state.is(newState.getBlock()) && level.getBlockState(pos.above()).getBlock() instanceof HeaterTopBlock) {
            level.removeBlock(pos.above(), false);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.isEmptyBlock(pos.above())) {
            level.setBlock(pos.above(), (BlockState)((HeaterTopBlock)((Object)BlockRegistry.HEATER_TOP.get())).defaultBlockState().setValue((Property)HeaterTopBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            float yr;
            float zr;
            float xr;
            float chance = 0.5f;
            float chance_flame = 0.4f;
            double posX = pos.getX();
            double posY = pos.getY();
            double posZ = pos.getZ();
            if (rand.nextFloat() < chance) {
                level.playLocalSound(posX + 0.5, posY + 0.5, posZ + 0.5, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (rand.nextFloat() < chance) {
                xr = rand.nextFloat() / 2.0f + 0.25f;
                float zr2 = rand.nextFloat() / 2.0f + 0.25f;
                float xm = rand.nextFloat() / 20.0f - 0.025f;
                float zm = rand.nextFloat() / 20.0f - 0.025f;
                float ym = rand.nextFloat() / 10.0f + 0.02f;
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, false, posX + (double)xr, (double)pos.above().getY() + 0.8, posZ + (double)zr2, (double)xm, (double)ym, (double)zm);
            }
            if (rand.nextFloat() < chance_flame) {
                zr = rand.nextFloat() / 3.0f + 0.33f;
                yr = rand.nextFloat() / 6.0f + 0.5f;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, posX + 0.05, posY + (double)yr, posZ + (double)zr, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, posX + 0.05, posY + (double)yr, posZ + (double)zr, 0.0, 0.0, 0.0);
            }
            if (rand.nextFloat() < chance_flame) {
                zr = rand.nextFloat() / 3.0f + 0.33f;
                yr = rand.nextFloat() / 6.0f + 0.5f;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, posX + 0.95, posY + (double)yr, posZ + (double)zr, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, posX + 0.95, posY + (double)yr, posZ + (double)zr, 0.0, 0.0, 0.0);
            }
            if (rand.nextFloat() < chance_flame) {
                xr = rand.nextFloat() / 3.0f + 0.33f;
                yr = rand.nextFloat() / 6.0f + 0.5f;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, posX + (double)xr, posY + (double)yr, posZ + 0.05, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, posX + (double)xr, posY + (double)yr, posZ + 0.05, 0.0, 0.0, 0.0);
            }
            if (rand.nextFloat() < chance_flame) {
                xr = rand.nextFloat() / 3.0f + 0.33f;
                yr = rand.nextFloat() / 6.0f + 0.5f;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, posX + (double)xr, posY + (double)yr, posZ + 0.95, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, posX + (double)xr, posY + (double)yr, posZ + 0.95, 0.0, 0.0, 0.0);
            }
        }
        super.animateTick(state, level, pos, rand);
    }
}

