/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.common.containers.SewingTableContainer;

public class SewingTableBlock
extends HorizontalDirectionalBlock
implements MenuProvider {
    public static final MapCodec<SewingTableBlock> CODEC = SewingTableBlock.simpleCodec(SewingTableBlock::new);
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.legendarysurvivaloverhaul.sewing_table").withStyle(new ChatFormatting[0]);
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape X_TOP = Block.box((double)6.0, (double)1.0, (double)2.0, (double)10.0, (double)10.0, (double)14.0);
    private static final VoxelShape Z_TOP = Block.box((double)2.0, (double)1.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0);
    private static final VoxelShape X_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)X_TOP);
    private static final VoxelShape Z_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)Z_TOP);

    public SewingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(4.0f, 10.0f).noOcclusion();
    }

    public MapCodec<SewingTableBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_AABB : Z_AABB;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.useWithoutItem(state, level, pos, player, hit) == InteractionResult.CONSUME ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((windowId, inv, player) -> new SewingTableContainer(windowId, inv, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    @NotNull
    public Component getDisplayName() {
        return CONTAINER_TITLE;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new SewingTableContainer(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
    }
}

