/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

public class WaterPlantBlock
extends CropBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static final BlockBehaviour.Properties properties = WaterPlantBlock.getProperties();
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)};

    public WaterPlantBlock() {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noOcclusion().noCollission().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY);
    }

    public void randomTick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && !this.isUpperBlock(state)) {
            float f;
            int age = this.getAge(state);
            if (this.canGrow((Level)level, state, pos) && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = WaterPlantBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.setBlock(pos, this.getStateForAge(age + 1), 2);
                if (this.getAge(state) > this.getMaxAge() / 2) {
                    level.setBlock(pos.above(), (BlockState)this.getStateForAge(age + 1).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                }
            }
        }
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        if (this.canGrow(level, state, pos)) {
            BlockPos basePos = pos;
            if (this.isUpperBlock(state)) {
                basePos = pos.below();
            }
            age = Math.min(age + this.getBonemealAgeIncrease(level), this.getMaxAge());
            level.setBlock(basePos, this.getStateForAge(age), 2);
            if (age > this.getMaxAge() / 2) {
                level.setBlock(basePos.above(), (BlockState)this.getStateForAge(age).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            }
        }
    }

    public boolean isUpperBlock(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER;
    }

    public boolean canGrow(Level level, BlockState state, BlockPos pos) {
        if (this.isUpperBlock(state) || level.isEmptyBlock(pos.above()) || level.getBlockState(pos.above()).is((Block)this)) {
            return this.getAge(state) < this.getMaxAge();
        }
        return this.getAge(state) < this.getMaxAge() / 2;
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ItemRegistry.WATER_PLANT_SEEDS.get();
    }

    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{HALF});
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.getBlock() == this && this.isUpperBlock(state)) {
            BlockState stateBelow = level.getBlockState(pos.below());
            return (level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos)) && stateBelow.getBlock() == this && this.getAge(stateBelow) > this.getMaxAge() / 2;
        }
        return super.canSurvive(state, level, pos);
    }

    protected boolean mayPlaceOn(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return blockState.is(BlockTags.SAND);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.getOffset(reader, pos);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BY_AGE[Math.min(this.getAge(state), 3)].move(vector3d.x, vector3d.y, vector3d.z);
        }
        return SHAPE_BY_AGE[this.getAge(state)].move(vector3d.x, vector3d.y, vector3d.z);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (this.isUpperBlock(state)) {
                if (level.getBlockState(pos.below()).is((Block)this)) {
                    level.removeBlock(pos.below(), false);
                }
            } else if (level.getBlockState(pos.above()).is((Block)this)) {
                level.removeBlock(pos.above(), false);
            }
            if (player.isCreative()) {
                level.removeBlock(pos, false);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.nextInt((RandomSource)pLevel.random, (int)1, (int)2);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.canGrow((Level)level, state, pos)) {
            return state.getBlock() == this;
        }
        return false;
    }
}

