/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class HealthCommand
extends CommandBase {
    public HealthCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"healthoverhaul").requires(p_198521_0_ -> p_198521_0_.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.literal((String)"shield").executes(src -> new HealthCommand().getShield((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"))))).then(Commands.literal((String)"additionalHealth").executes(src -> new HealthCommand().getHealth((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"))))).then(Commands.literal((String)"brokenHearts").executes(src -> new HealthCommand().getBrokenHeart((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"shield").then(Commands.argument((String)"shieldValue", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Config.Baked.maxShieldHealth)).executes(src -> new HealthCommand().setShield((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), DoubleArgumentType.getDouble((CommandContext)src, (String)"shieldValue")))))).then(Commands.literal((String)"additionalHealth").then(Commands.argument((String)"healthValue", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Config.Baked.maxAdditionalHealth)).executes(src -> new HealthCommand().setHealth((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), DoubleArgumentType.getDouble((CommandContext)src, (String)"healthValue")))))))));
    }

    private int getShield(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.getEntity() instanceof Player)) continue;
                reply.append("Player ").append(player.getName().getString()).append(" ");
                float shieldValue = AttachmentUtil.getHealthAttachment(player).getShieldHealth();
                reply.append("Shield: ").append(shieldValue).append("\n");
                src.sendSuccess(() -> Component.literal((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int getHealth(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.getEntity() instanceof Player)) continue;
                reply.append("Player ").append(player.getName().getString()).append(" ");
                float healthValue = AttachmentUtil.getHealthAttachment(player).getAdditionalHealth();
                reply.append("Additional Health: ").append(healthValue).append("\n");
                src.sendSuccess(() -> Component.literal((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int getBrokenHeart(CommandSourceStack src, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(src.getEntity() instanceof Player)) continue;
                reply.append("Player ").append(player.getName().getString()).append(" ");
                float brokenHearts = (int)player.getAttributeValue(AttributeRegistry.BROKEN_HEART);
                reply.append("Broken Hearts: ").append(brokenHearts).append("\n");
                src.sendSuccess(() -> Component.literal((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int setShield(CommandSourceStack src, Collection<? extends Entity> entities, double shieldValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            AttachmentUtil.getHealthAttachment(player).setShieldHealth((float)shieldValue);
        }
        return 1;
    }

    private int setHealth(CommandSourceStack src, Collection<? extends Entity> entities, double healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            AttachmentUtil.getHealthAttachment(player).setAdditionalHealth((float)healthValue);
        }
        return 1;
    }
}

