/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class TemperatureCommand
extends CommandBase {
    public TemperatureCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"temperature").requires(p_198521_0_ -> p_198521_0_.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"Temperature", (ArgumentType)IntegerArgumentType.integer((int)TemperatureEnum.FROSTBITE.getLowerBound(), (int)TemperatureEnum.HEAT_STROKE.getUpperBound())).executes(src -> new TemperatureCommand().set((CommandSourceStack)src.getSource(), IntegerArgumentType.getInteger((CommandContext)src, (String)"Temperature")))))).then(Commands.literal((String)"get").executes(src -> new TemperatureCommand().get((CommandSourceStack)src.getSource())))));
    }

    @Override
    public int get(CommandSourceStack source) {
        try {
            Entity entity = source.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                float targetTemperature = TemperatureUtil.getPlayerTargetTemperature(player);
                TemperatureAttachment cap = AttachmentUtil.getTempAttachment(player);
                float playerTemp = MathUtil.round(cap.getTemperatureLevel(), 2);
                float worldTemp = TemperatureUtil.getWorldTemperature(player.level(), player.blockPosition());
                String reply = "Temp: " + playerTemp + "\nTarget Temp: " + targetTemperature + "\nWorld Temp: " + worldTemp;
                source.sendSuccess(() -> Component.literal((String)reply), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int set(CommandSourceStack src, int temp) throws CommandSyntaxException {
        AttachmentUtil.getTempAttachment((Player)src.getPlayerOrException()).setTemperatureLevel(temp);
        return 1;
    }
}

