/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class ThirstCommand
extends CommandBase {
    public ThirstCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"thirst").requires(p_198521_0_ -> p_198521_0_.hasPermission(2))).then(Commands.literal((String)"get").executes(src -> new ThirstCommand().get((CommandSourceStack)src.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"hydration").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(src -> new ThirstCommand().setHydration((CommandSourceStack)src.getSource(), IntegerArgumentType.getInteger((CommandContext)src, (String)"value")))))).then(Commands.literal((String)"saturation").then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)20.0f)).executes(src -> new ThirstCommand().setSaturation((CommandSourceStack)src.getSource(), FloatArgumentType.getFloat((CommandContext)src, (String)"value")))))).then(Commands.literal((String)"exhaustion").then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)4.0f)).executes(src -> new ThirstCommand().setExhaustion((CommandSourceStack)src.getSource(), FloatArgumentType.getFloat((CommandContext)src, (String)"value"))))))));
    }

    @Override
    public int get(CommandSourceStack source) {
        try {
            Entity entity = source.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ThirstAttachment cap = AttachmentUtil.getThirstAttachment(player);
                int hydration = cap.getHydrationLevel();
                float saturation = MathUtil.round(cap.getSaturationLevel(), 2);
                float exhaustion = MathUtil.round(cap.getThirstExhaustion(), 2);
                String reply = "Hydration: " + hydration + "/20\nSaturation: " + saturation + "\nExhaustion: " + exhaustion;
                source.sendSuccess(() -> Component.literal((String)reply), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int setHydration(CommandSourceStack src, int value) throws CommandSyntaxException {
        ThirstAttachment cap = AttachmentUtil.getThirstAttachment((Player)src.getPlayerOrException());
        cap.setHydrationLevel(value);
        src.sendSuccess(() -> Component.literal((String)("Set hydration to " + value)), false);
        return 1;
    }

    private int setSaturation(CommandSourceStack src, float value) throws CommandSyntaxException {
        ThirstAttachment cap = AttachmentUtil.getThirstAttachment((Player)src.getPlayerOrException());
        cap.setThirstSaturation(value);
        src.sendSuccess(() -> Component.literal((String)("Set saturation to " + value)), false);
        return 1;
    }

    private int setExhaustion(CommandSourceStack src, float value) throws CommandSyntaxException {
        ThirstAttachment cap = AttachmentUtil.getThirstAttachment((Player)src.getPlayerOrException());
        cap.setThirstExhaustion(value);
        src.sendSuccess(() -> Component.literal((String)("Set exhaustion to " + value)), false);
        return 1;
    }
}

