/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.jei;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.client.screens.SewingTableScreen;
import sfiomn.legendarysurvivaloverhaul.common.integration.jei.SewingRecipeCategory;
import sfiomn.legendarysurvivaloverhaul.common.integration.mutantmonsters.MutantMonstersUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.CoatItem;
import sfiomn.legendarysurvivaloverhaul.common.recipe.SewingRecipe;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SewingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (Config.Baked.thirstEnabled) {
            registration.registerSubtypeInterpreter((Item)ItemRegistry.CANTEEN.get(), (ISubtypeInterpreter)CanteenSubtypeInterpreter.INSTANCE);
            registration.registerSubtypeInterpreter((Item)ItemRegistry.LARGE_CANTEEN.get(), (ISubtypeInterpreter)CanteenSubtypeInterpreter.INSTANCE);
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.getInstance().level;
        if (Config.Baked.temperatureEnabled) {
            if (world != null) {
                RecipeManager rm = world.getRecipeManager();
                registration.addRecipes(SewingRecipeCategory.SEWING_RECIPE_TYPE, rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)SewingRecipe.Type.INSTANCE).stream().map(holder -> (SewingRecipe)holder.value()).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            registration.addRecipes(SewingRecipeCategory.SEWING_RECIPE_TYPE, this.sewingCoatRecipes());
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeClickArea(SewingTableScreen.class, 40, 37, 20, 20, new RecipeType[]{SewingRecipeCategory.SEWING_RECIPE_TYPE});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (Config.Baked.temperatureEnabled) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SEWING_TABLE.get()), new RecipeType[]{SewingRecipeCategory.SEWING_RECIPE_TYPE});
        }
    }

    private ArrayList<SewingRecipe> sewingCoatRecipes() {
        ArrayList<SewingRecipe> sewingRecipes = new ArrayList<SewingRecipe>();
        BuiltInRegistries.ITEM.stream().forEach(item -> {
            if ((item instanceof ArmorItem || MutantMonstersUtil.isMutantMonstersArmor(item)) && BuiltInRegistries.ITEM.getKey(item) != null) {
                this.addSewingRecipe((Item)item, sewingRecipes);
            }
        });
        return sewingRecipes;
    }

    private void addSewingRecipe(Item itemArmor, ArrayList<SewingRecipe> sewingRecipes) {
        ResourceLocation itemArmorRegistryName = BuiltInRegistries.ITEM.getKey((Object)itemArmor);
        for (DeferredHolder modItem : ItemRegistry.ITEMS.getEntries()) {
            Object object = modItem.get();
            if (!(object instanceof CoatItem)) continue;
            CoatItem itemCoat = (CoatItem)((Object)object);
            if (itemArmorRegistryName == null) continue;
            ItemStack result = new ItemStack((ItemLike)itemArmor);
            TemperatureUtil.setArmorCoatTag(result, itemCoat.coat.id());
            sewingRecipes.add(this.getCoatRecipe(itemArmor, itemCoat, result));
        }
    }

    private SewingRecipe getCoatRecipe(Item base, Item addition, ItemStack result) {
        return new SewingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{base}), Ingredient.of((ItemLike[])new ItemLike[]{addition}), result);
    }

    public static class CanteenSubtypeInterpreter
    implements ISubtypeInterpreter<ItemStack> {
        public static final CanteenSubtypeInterpreter INSTANCE = new CanteenSubtypeInterpreter();

        private CanteenSubtypeInterpreter() {
        }

        public Object getSubtypeData(ItemStack itemStack, UidContext context) {
            CustomData custom = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
            if (custom == null) {
                return "";
            }
            CompoundTag tag = custom.copyTag();
            if (!tag.contains("legendarysurvivaloverhaul:HydrationPurity")) {
                return "";
            }
            return tag.getString("legendarysurvivaloverhaul:HydrationPurity");
        }

        public String getLegacyStringSubtypeInfo(ItemStack itemStack, UidContext context) {
            CustomData custom = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
            if (custom == null) {
                return "";
            }
            CompoundTag tag = custom.copyTag();
            if (!tag.contains("legendarysurvivaloverhaul:HydrationPurity")) {
                return "";
            }
            return tag.getString("legendarysurvivaloverhaul:HydrationPurity");
        }
    }
}

