/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.item.CoatEnum;
import sfiomn.legendarysurvivaloverhaul.registry.KeyMappingRegistry;

public class CoatItem
extends Item {
    public CoatEnum coat;

    public CoatItem(CoatEnum coat, Item.Properties properties) {
        super(properties);
        this.coat = coat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        MutableComponent text;
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        boolean showDetails = false;
        if (RenderSystem.isOnRenderThread()) {
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            int key = KeyMappingRegistry.showAddedDesc.getKey().getValue();
            if (windowHandle != 0L && key != -1) {
                showDetails = InputConstants.isKeyDown((long)windowHandle, (int)key);
            }
        }
        if (showDetails) {
            if (this.coat == null) return;
            MutableComponent effectComponent = Component.translatable((String)("tooltip.legendarysurvivaloverhaul.coat_item." + this.coat.type() + ".effect")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6466303)));
            MutableComponent temperatureComponent = Component.literal((String)(" " + this.coat.modifier()));
            if (Objects.equals(this.coat.type(), "heating")) {
                effectComponent = effectComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6466303)));
                temperatureComponent = temperatureComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6466303)));
            } else if (Objects.equals(this.coat.type(), "cooling")) {
                effectComponent = effectComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16420407)));
                temperatureComponent = temperatureComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16420407)));
            } else {
                effectComponent = effectComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x9933FF)));
                temperatureComponent = temperatureComponent.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x9933FF)));
            }
            text = Component.translatable((String)"tooltip.legendarysurvivaloverhaul.coat_item.desc", (Object[])new Object[]{effectComponent}).append((Component)temperatureComponent);
        } else {
            text = Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + I18n.get((String)"tooltip.legendarysurvivaloverhaul.added_desc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, I18n.get((String)KeyMappingRegistry.showAddedDesc.getTranslatedKeyMessage().getString(), (Object[])new Object[0]), ChatFormatting.GRAY})));
        }
        tooltipComponents.add((Component)text);
    }
}

