/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.WearableCurioItem;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class NetherChaliceItem
extends WearableCurioItem {
    public NetherChaliceItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (LegendarySurvivalOverhaul.curiosLoaded) {
            return super.use(level, player, usedHand);
        }
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (AttachmentUtil.getThirstAttachment(player).isHydrationLevelAtMax()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        HitResult positionLookedAt = player.pick(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) / 2.0, 0.0f, true);
        FluidState fluidState = null;
        if (positionLookedAt.getType() == HitResult.Type.BLOCK) {
            fluidState = level.getFluidState(((BlockHitResult)positionLookedAt).getBlockPos());
        }
        if (fluidState != null && (fluidState.is((Fluid)Fluids.LAVA) || fluidState.is((Fluid)Fluids.FLOWING_LAVA))) {
            player.swing(InteractionHand.MAIN_HAND);
            player.playSound(SoundEvents.GENERIC_DRINK, 1.0f, 1.0f);
            ThirstUtil.takeDrink(player, Config.Baked.hydrationLava, (float)Config.Baked.saturationLava);
            return InteractionResultHolder.pass((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.nether_chalice.description"));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

