/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items.drink;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonMobEffect;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.api.wetness.WetnessUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.drink.DrinkItem;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class CanteenItem
extends DrinkItem {
    public CanteenItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static boolean canDrink(ItemStack stack) {
        return ThirstUtil.getCapacityTag(stack) > 0 && ThirstUtil.getHydrationEnumTag(stack) != null;
    }

    public static void shrinkCapacity(ItemStack stack) {
        int newCapacity = ThirstUtil.getCapacityTag(stack) - 1;
        ThirstUtil.setCapacityTag(stack, newCapacity);
        if (newCapacity == 0) {
            ThirstUtil.removeHydrationEnumTag(stack);
        }
    }

    public int getMaxCapacity() {
        return Config.Baked.canteenCapacity;
    }

    @Override
    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return CanteenItem.canDrink(stack) ? 40 : 0;
    }

    public boolean canFill(ItemStack stack) {
        return Config.Baked.allowOverridePurifiedWater ? ThirstUtil.getCapacityTag(stack) < this.getMaxCapacity() : ThirstUtil.getCapacityTag(stack) < this.getMaxCapacity() && ThirstUtil.getHydrationEnumTag(stack) != HydrationEnum.PURIFIED;
    }

    public void fill(ItemStack stack) {
        ThirstUtil.setCapacityTag(stack, Math.min(this.getMaxCapacity(), ThirstUtil.getCapacityTag(stack) + 1));
        ThirstUtil.setHydrationEnumTag(stack, HydrationEnum.NORMAL);
    }

    public boolean isWater(Level level, BlockPos blockPos) {
        FluidState fluidState = level.getFluidState(blockPos);
        JsonThirstBlock thirstInfo = ThirstDataManager.getBlock(fluidState);
        if (thirstInfo == null) {
            thirstInfo = ThirstDataManager.getBlock(level.getBlockState(blockPos));
        }
        if (thirstInfo != null && thirstInfo.hydration == 3 && thirstInfo.saturation == 0.0f && !thirstInfo.effects.isEmpty()) {
            for (JsonMobEffect jsonMobEffect : thirstInfo.effects) {
                if (!jsonMobEffect.name.equalsIgnoreCase(MobEffectRegistry.THIRST.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        boolean isWater = this.isWater(useOnContext.getLevel(), useOnContext.getClickedPos());
        ItemStack canteen = useOnContext.getItemInHand();
        Player player = useOnContext.getPlayer();
        if (this.canFill(canteen) && isWater && player != null) {
            player.swing(InteractionHand.MAIN_HAND, true);
            useOnContext.getLevel().playSound(player, player.blockPosition(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.fill(canteen);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack canteen;
        HitResult positionLookedAt = player.pick(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) / 2.0, 0.0f, true);
        boolean isWater = false;
        if (positionLookedAt.getType() == HitResult.Type.BLOCK) {
            isWater = this.isWater(level, ((BlockHitResult)positionLookedAt).getBlockPos());
        }
        if (this.canFill(canteen = player.getItemInHand(hand)) && isWater) {
            player.swing(InteractionHand.MAIN_HAND);
            player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 1.0f);
            this.fill(canteen);
            return InteractionResultHolder.consume((Object)canteen);
        }
        if (player.isCrouching() && player.getViewXRot(1.0f) < -60.0f && CanteenItem.canDrink(canteen) && Config.Baked.selfWateringCanteenEnabled) {
            player.playSound((SoundEvent)SoundRegistry.SELF_WATERING.get(), 1.0f, 1.0f);
            if (player.isOnFire()) {
                player.clearFire();
            }
            if (Config.Baked.selfWateringCanteenWetnessIncrease > 0) {
                WetnessUtil.addWetness(player, Config.Baked.selfWateringCanteenWetnessIncrease);
            }
            player.swing(InteractionHand.MAIN_HAND);
            CanteenItem.shrinkCapacity(canteen);
            return InteractionResultHolder.consume((Object)canteen);
        }
        if (CanteenItem.canDrink(canteen) && !AttachmentUtil.getThirstAttachment(player).isHydrationLevelAtMax()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)canteen);
        }
        return InteractionResultHolder.fail((Object)canteen);
    }

    @Override
    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity) {
        if (level.isClientSide || !(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        this.runSecondaryEffect(player, stack);
        CanteenItem.shrinkCapacity(stack);
        return stack;
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        if (ThirstUtil.getCapacityTag(stack) == 0) {
            return "item.legendarysurvivaloverhaul.canteen_empty";
        }
        if (ThirstUtil.getHydrationEnumTag(stack) == HydrationEnum.PURIFIED) {
            return "item.legendarysurvivaloverhaul.canteen_purified";
        }
        return "item.legendarysurvivaloverhaul.canteen";
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return ThirstUtil.getCapacityTag(stack) > 0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        float max = this.getMaxCapacity();
        if (max == 0.0f) {
            return 0;
        }
        return Math.round((float)ThirstUtil.getCapacityTag(stack) / max * 13.0f);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        float f = Math.max(0.0f, (float)ThirstUtil.getCapacityTag(stack) / (float)this.getMaxCapacity());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

