/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items.heal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;

public class MorphineItem
extends Item {
    public MorphineItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return Config.Baked.morphineUseTime;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.hasEffect(MobEffectRegistry.PAINKILLER_ADDICTION)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarysurvivaloverhaul.morphine_use_under_painkiller_addiction"), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)stack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity) {
        if (level.isClientSide || !(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        player.addEffect(new MobEffectInstance(MobEffectRegistry.PAINKILLER, Config.Baked.morphinePainkillerTickDuration, 0, false, false, true));
        player.addEffect(new MobEffectInstance(MobEffectRegistry.PAINKILLER_ADDICTION, Config.Baked.painkillerAddictionDuration, 0, false, false, true));
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return stack;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext level, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        if (Config.Baked.localizedBodyDamageEnabled) {
            tooltip.add((Component)Component.translatable((String)"tooltip.legendarysurvivaloverhaul.body_heal_item.morphine"));
        }
        super.appendHoverText(stack, level, tooltip, isAdvanced);
    }
}

