/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBiomeOverride;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureBiomeManager;
import sfiomn.legendarysurvivaloverhaul.network.payloads.SyncTemperatureBiomesPayload;

public class TemperatureBiomeListener
extends SimpleJsonResourceReloadListener
implements ITemperatureBiomeManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureBiomeOverride> TEMPERATURE_BIOMES = new HashMap<ResourceLocation, JsonTemperatureBiomeOverride>();

    public TemperatureBiomeListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/biomes");
    }

    public static void sendDataToClient(@Nullable ServerPlayer player) {
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureBiomesPayload(TEMPERATURE_BIOMES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureBiomesPayload(TEMPERATURE_BIOMES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void acceptServerTemperatureBiomes(Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes) {
        TEMPERATURE_BIOMES.clear();
        TEMPERATURE_BIOMES.putAll(temperatureBiomes);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_BIOMES.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureBiomeOverride.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureBiomeOverride temperatures = (JsonTemperatureBiomeOverride)parsedJson.getOrThrow(err -> new IllegalStateException("Failed parsing temperature biome: " + err));
                if (ModList.get().isLoaded(key.getNamespace())) {
                    TEMPERATURE_BIOMES.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException | IllegalStateException error) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature biome json {}", key, (Object)error);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature biomes", (Object)TEMPERATURE_BIOMES.size());
    }

    @Override
    public JsonTemperatureBiomeOverride get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_BIOMES.get(itemRegistryName);
    }
}

