/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumableBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureConsumableBlockManager;
import sfiomn.legendarysurvivaloverhaul.network.payloads.SyncTemperatureConsumableBlocksPayload;

public class TemperatureConsumableBlockListener
extends SimpleJsonResourceReloadListener
implements ITemperatureConsumableBlockManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> TEMPERATURE_CONSUMABLE_BLOCKS = new HashMap<ResourceLocation, List<JsonTemperatureConsumableBlock>>();

    public TemperatureConsumableBlockListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/consumable_blocks");
    }

    public static void sendDataToClient(@Nullable ServerPlayer player) {
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureConsumableBlocksPayload(TEMPERATURE_CONSUMABLE_BLOCKS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureConsumableBlocksPayload(TEMPERATURE_CONSUMABLE_BLOCKS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void acceptServerTemperatureConsumableBlocks(Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks) {
        TEMPERATURE_CONSUMABLE_BLOCKS.clear();
        TEMPERATURE_CONSUMABLE_BLOCKS.putAll(temperatureConsumableBlocks);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_CONSUMABLE_BLOCKS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureConsumableBlock.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                List temperatures = (List)parsedJson.getOrThrow(err -> new IllegalStateException("Failed parsing temperature consumable block: " + err));
                if (ModList.get().isLoaded(key.getNamespace())) {
                    TEMPERATURE_CONSUMABLE_BLOCKS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException | IllegalStateException error) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature consumable block json {}", key, (Object)error);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature consumable blocks", (Object)TEMPERATURE_CONSUMABLE_BLOCKS.size());
    }

    @Override
    public List<JsonTemperatureConsumableBlock> get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_CONSUMABLE_BLOCKS.get(itemRegistryName);
    }
}

