/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureMountManager;
import sfiomn.legendarysurvivaloverhaul.network.payloads.SyncTemperatureMountsPayload;

public class TemperatureMountListener
extends SimpleJsonResourceReloadListener
implements ITemperatureMountManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureResistance> TEMPERATURE_MOUNTS = new HashMap<ResourceLocation, JsonTemperatureResistance>();

    public TemperatureMountListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/mounts");
    }

    public static void sendDataToClient(@Nullable ServerPlayer player) {
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureMountsPayload(TEMPERATURE_MOUNTS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureMountsPayload(TEMPERATURE_MOUNTS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void acceptServerTemperatureMounts(Map<ResourceLocation, JsonTemperatureResistance> temperatureMounts) {
        TEMPERATURE_MOUNTS.clear();
        TEMPERATURE_MOUNTS.putAll(temperatureMounts);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_MOUNTS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureResistance.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureResistance temperature = (JsonTemperatureResistance)parsedJson.getOrThrow(err -> new IllegalStateException("Failed parsing temperature mount: " + err));
                if (ModList.get().isLoaded(key.getNamespace())) {
                    TEMPERATURE_MOUNTS.put((ResourceLocation)key, temperature);
                }
            }
            catch (JsonParseException | IllegalStateException error) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature mount json {}", key, (Object)error);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature mounts", (Object)TEMPERATURE_MOUNTS.size());
    }

    @Override
    public JsonTemperatureResistance get(ResourceLocation mountRegistryName) {
        return TEMPERATURE_MOUNTS.get(mountRegistryName);
    }
}

