/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SewingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;

    public SewingRecipe(Ingredient base, Ingredient addition, ItemStack result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public boolean matches(@NotNull RecipeInput input, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.base.test(input.getItem(0)) && this.addition.test(input.getItem(1));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput input, @NotNull HolderLookup.Provider provider) {
        ItemStack itemstack = this.result.copy();
        ItemStack base = input.getItem(0);
        CustomData custom = (CustomData)base.get(DataComponents.CUSTOM_DATA);
        if (custom != null) {
            itemstack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)custom.copyTag()));
        }
        return itemstack;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SewingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"sewing");
        private static final MapCodec<SewingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(SewingRecipe::getBase), (App)Ingredient.CODEC.fieldOf("addition").forGetter(SewingRecipe::getAddition), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result)).apply((Applicative)instance, SewingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SewingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.base, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.addition, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.result, SewingRecipe::new);

        public MapCodec<SewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<SewingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"sewing");
    }
}

