/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.temperature.dynamic;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.temperature.DynamicModifierBase;

public class MountDynamicModifier
extends DynamicModifierBase {
    @Override
    public float applyDynamicPlayerInfluence(Player player, float currentTemperature, float currentResistance) {
        if (player.getVehicle() == null) {
            return 0.0f;
        }
        return this.getEffectiveResistance(currentTemperature, currentResistance, this.processMountJson(player.getVehicle()));
    }

    private JsonTemperatureResistance processMountJson(Entity entity) {
        ResourceLocation entityRegistryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        JsonTemperatureResistance jsonTemperatureResistance = TemperatureDataManager.getMount(entityRegistryName);
        return Objects.requireNonNullElseGet(jsonTemperatureResistance, JsonTemperatureResistance::new);
    }
}

