/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import sfiomn.legendarysurvivaloverhaul.data.integration.IntegrationDataGenerators;
import sfiomn.legendarysurvivaloverhaul.data.providers.MinecraftBodyDamageProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.MinecraftTemperatureProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.MinecraftThirstProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModAdvancementProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModBlockStateProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModBlockTagProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModBodyDamageProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModDamageTypeTagsProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModDatapackBuiltinEntriesProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModEntityTypesTagProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModGlobalLootModifierProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModItemModelProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModItemTagProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModLootTableProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModRecipeProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModTemperatureProvider;
import sfiomn.legendarysurvivaloverhaul.data.providers.ModThirstProvider;

@EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ModEntityTypesTagProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.createLootTables(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        ModBlockTagProvider blockTagProvider = (ModBlockTagProvider)gen.addProvider(event.includeServer(), (DataProvider)new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ModTemperatureProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModThirstProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModBodyDamageProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinecraftBodyDamageProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinecraftThirstProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinecraftTemperatureProvider(packOutput, lookupProvider, existingFileHelper));
        IntegrationDataGenerators.addIntegrationProviders(event, gen, packOutput, lookupProvider, existingFileHelper);
    }
}

