/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureOriginListener;

public record SyncTemperatureOriginsPayload(Map<ResourceLocation, JsonTemperatureResistance> temperatureOrigins) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"sync_temperature_origins");
    public static final CustomPacketPayload.Type<SyncTemperatureOriginsPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncTemperatureOriginsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.fromCodecTrusted(JsonTemperatureResistance.CODEC)), SyncTemperatureOriginsPayload::temperatureOrigins, SyncTemperatureOriginsPayload::new);

    public static void handle(SyncTemperatureOriginsPayload pkt, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.enqueueWork(() -> TemperatureOriginListener.acceptServerTemperatureOrigins(pkt.temperatureOrigins()));
    }

    public static void sendToServer(Map<ResourceLocation, JsonTemperatureResistance> data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncTemperatureOriginsPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, Map<ResourceLocation, JsonTemperatureResistance> data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureOriginsPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(Map<ResourceLocation, JsonTemperatureResistance> data) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureOriginsPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

