/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public record UpdateBodyDamagePayload(CompoundTag compound) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"update_body_damage");
    public static final CustomPacketPayload.Type<UpdateBodyDamagePayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateBodyDamagePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, UpdateBodyDamagePayload::compound, UpdateBodyDamagePayload::new);

    public static void handle(UpdateBodyDamagePayload pkt, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player != null) {
                BodyDamageAttachment bodyDamageAttachment = AttachmentUtil.getBodyDamageAttachment(player);
                bodyDamageAttachment.readNBT(pkt.compound());
            }
        });
    }

    public static void sendToServer(CompoundTag compound) {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateBodyDamagePayload(compound), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, CompoundTag compound) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateBodyDamagePayload(compound), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(CompoundTag compound) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateBodyDamagePayload(compound), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

