/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.registry;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.blocks.CoolerBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterBaseBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterTopBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.IceFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.IceFernGoldBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SewingTableBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SunFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SunFernGoldBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.WaterPlantBlock;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"legendarysurvivaloverhaul");
    public static final DeferredHolder<Block, HeaterBaseBlock> HEATER = BlockRegistry.registerBlock("heater", () -> new HeaterBaseBlock(ThermalTypeEnum.HEATING));
    public static final DeferredHolder<Block, HeaterTopBlock> HEATER_TOP = BLOCKS.register("heater_top", () -> new HeaterTopBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.5f).sound(SoundType.METAL).noOcclusion()));
    public static final DeferredHolder<Block, CoolerBlock> COOLER = BlockRegistry.registerBlock("cooler", () -> new CoolerBlock(ThermalTypeEnum.COOLING));
    public static final DeferredHolder<Block, SewingTableBlock> SEWING_TABLE = BlockRegistry.registerBlock("sewing_table", () -> new SewingTableBlock(SewingTableBlock.getProperties()));
    public static final DeferredHolder<Block, SunFernBlock> SUN_FERN_CROP = BLOCKS.register("sun_fern_crop", SunFernBlock::new);
    public static final DeferredHolder<Block, SunFernGoldBlock> SUN_FERN_GOLD = BlockRegistry.registerBlock("sun_fern_gold", () -> new SunFernGoldBlock(SunFernGoldBlock.getProperties()));
    public static final DeferredHolder<Block, IceFernBlock> ICE_FERN_CROP = BLOCKS.register("ice_fern_crop", IceFernBlock::new);
    public static final DeferredHolder<Block, IceFernGoldBlock> ICE_FERN_GOLD = BlockRegistry.registerBlock("ice_fern_gold", () -> new IceFernGoldBlock(IceFernGoldBlock.getProperties()));
    public static final DeferredHolder<Block, WaterPlantBlock> WATER_PLANT_CROP = BLOCKS.register("water_plant_crop", WaterPlantBlock::new);

    private static <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> block) {
        DeferredHolder holder = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, holder);
        return holder;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredHolder<Block, T> block) {
        ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

