/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class SpreadPoint {
    private final BlockPos pos;
    private final Direction originDirection;
    private final double spreadCapacity;
    private final double influenceDistance;
    private final Level level;
    private final BlockState blockState;
    private boolean canSeeSky;
    private boolean isWater;

    public SpreadPoint(BlockPos pos, Direction originDirection, double spreadCapacity, double influenceDistance, Level level) {
        this.pos = pos;
        this.originDirection = originDirection;
        this.spreadCapacity = spreadCapacity;
        this.influenceDistance = influenceDistance;
        this.level = level;
        this.blockState = level.getBlockState(pos);
        this.canSeeSky = false;
        this.isWater = false;
    }

    public double influenceDistance() {
        return this.influenceDistance;
    }

    public BlockPos position() {
        return this.pos;
    }

    public Direction originalDirection() {
        return this.originDirection;
    }

    public double spreadCapacity() {
        return this.spreadCapacity;
    }

    public SpreadPoint spreadTo(BlockPos newBlockPos, Direction originDirection, float distance) {
        return new SpreadPoint(newBlockPos, originDirection, this.spreadCapacity - (double)distance * this.consumptionMultiplier(originDirection), this.influenceDistance + (double)distance, this.level);
    }

    public boolean isValidSpreadPoint(Direction originDirection) {
        if (this.spreadCapacity <= 0.0) {
            return false;
        }
        if (this.blockState.isAir()) {
            return true;
        }
        if (this.blockState.is(Blocks.WATER)) {
            this.isWater = true;
            return true;
        }
        return !this.blockState.isFaceSturdy((BlockGetter)this.level, this.pos, originDirection.getOpposite());
    }

    public boolean isValidSpreadDirection(Direction direction) {
        return !this.blockState.isFaceSturdy((BlockGetter)this.level, this.pos, direction);
    }

    public void setCanSeeSky(boolean canSeeSky) {
        this.canSeeSky = canSeeSky;
    }

    private double consumptionMultiplier(Direction originDirection) {
        boolean upDirection = originDirection.getNormal().getY() > 0;
        double consumptionMultiplier = 1.0;
        if (this.isWater) {
            consumptionMultiplier *= Config.Baked.tempInfluenceInWaterDistMultiplier;
        } else if (this.canSeeSky) {
            consumptionMultiplier *= Config.Baked.tempInfluenceOutsideDistMultiplier;
        }
        if (upDirection) {
            consumptionMultiplier *= Config.Baked.tempInfluenceUpDistMultiplier;
        }
        return 1.0 / consumptionMultiplier;
    }
}

