/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumableBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.temperature.DynamicModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ITemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureImmunityEnum;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.AttributeBuilder;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class TemperatureUtilInternal
implements ITemperatureUtil {
    public static final String COAT_TAG = "Coat";
    public static final AttributeBuilder HEATING_TEMPERATURE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.HEATING_TEMPERATURE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"heating_temperature"));
    public static final AttributeBuilder COOLING_TEMPERATURE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.COOLING_TEMPERATURE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"cooling_temperature"));
    public static final AttributeBuilder HEAT_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.HEAT_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"heat_resistance"));
    public static final AttributeBuilder COLD_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.COLD_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"cold_resistance"));
    public static final AttributeBuilder THERMAL_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.THERMAL_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"thermal_resistance"));
    public static final Map<EquipmentSlot, UUID> equipmentSlotTemperatureUuid = new HashMap<EquipmentSlot, UUID>();

    @Override
    public float getPlayerTargetTemperature(Player player) {
        float sum = 0.0f;
        Level world = player.getCommandSenderWorld();
        BlockPos pos = WorldUtil.getSidedBlockPos(world, (Entity)player);
        for (DeferredHolder holder : TemperatureModifierRegistry.MODIFIERS.getEntries()) {
            ModifierBase modifier = (ModifierBase)holder.get();
            float worldInfluence = modifier.getWorldInfluence(player, world, pos);
            float playerInfluence = modifier.getPlayerInfluence(player);
            if (player.getMainHandItem().is(Items.DEBUG_STICK)) {
                LegendarySurvivalOverhaul.LOGGER.info("{} : world influence={}, player influence={}", (Object)holder.getId(), (Object)Float.valueOf(worldInfluence), (Object)Float.valueOf(playerInfluence));
            }
            sum += worldInfluence + playerInfluence;
        }
        float dynamicModification = 0.0f;
        for (DeferredHolder holder : TemperatureModifierRegistry.DYNAMIC_MODIFIERS.getEntries()) {
            DynamicModifierBase dynamicModifier = (DynamicModifierBase)holder.get();
            float worldInfluence = dynamicModifier.applyDynamicWorldInfluence(player, world, pos, sum, dynamicModification);
            float playerInfluence = dynamicModifier.applyDynamicPlayerInfluence(player, sum, dynamicModification);
            if (player.getMainHandItem().is(Items.DEBUG_STICK)) {
                LegendarySurvivalOverhaul.LOGGER.info("{} : dynamic world influence={}, dynamic player influence={}", (Object)holder.getId(), (Object)Float.valueOf(worldInfluence), (Object)Float.valueOf(playerInfluence));
            }
            dynamicModification += worldInfluence + playerInfluence;
        }
        return MathUtil.round(sum += dynamicModification, 1);
    }

    @Override
    public float getWorldTemperature(Level world, BlockPos pos) {
        float sum = 0.0f;
        for (DeferredHolder holder : TemperatureModifierRegistry.MODIFIERS.getEntries()) {
            ModifierBase modifier = (ModifierBase)holder.get();
            sum += modifier.getWorldInfluence(null, world, pos);
        }
        float dynamicModification = 0.0f;
        for (DeferredHolder holder : TemperatureModifierRegistry.DYNAMIC_MODIFIERS.getEntries()) {
            DynamicModifierBase dynamicModifier = (DynamicModifierBase)holder.get();
            dynamicModification += dynamicModifier.applyDynamicWorldInfluence(null, world, pos, sum, dynamicModification);
        }
        return MathUtil.round(sum += dynamicModification, 1);
    }

    @Override
    public TemperatureEnum getTemperatureEnum(float temperature) {
        return TemperatureEnum.get(temperature);
    }

    @Override
    public boolean hasImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return false;
        }
        TemperatureAttachment cap = AttachmentUtil.getTempAttachment(player);
        return cap.getTemperatureImmunities().contains(immunity.id);
    }

    @Override
    public void addImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return;
        }
        TemperatureAttachment cap = AttachmentUtil.getTempAttachment(player);
        cap.addTemperatureImmunityId(immunity.id);
    }

    @Override
    public void removeImmunity(Player player, TemperatureImmunityEnum immunity) {
        if (!Config.Baked.temperatureEnabled) {
            return;
        }
        TemperatureAttachment cap = AttachmentUtil.getTempAttachment(player);
        cap.removeTemperatureImmunityId(immunity.id);
    }

    @Override
    public void applyConsumableTemperature(Player player, ResourceLocation itemRegistryName) {
        List<JsonTemperatureConsumable> jsonConsumableTemperatures;
        if (Config.Baked.temperatureEnabled && (jsonConsumableTemperatures = TemperatureDataManager.getConsumable(itemRegistryName)) != null) {
            for (JsonTemperatureConsumable jtc : jsonConsumableTemperatures) {
                if (jtc.getEffect() == null) continue;
                player.addEffect(new MobEffectInstance(jtc.getEffectHolder(), jtc.duration, Math.abs(jtc.temperatureLevel) - 1, false, false, true));
                if (jtc.getOppositeEffectHolder() == null) continue;
                player.removeEffect(jtc.getOppositeEffectHolder());
            }
        }
    }

    @Override
    public void applyConsumableBlockTemperature(Player player, BlockState blockState) {
        ResourceLocation blockRegistryName;
        List<JsonTemperatureConsumableBlock> jsonConsumableBlockTemperatures;
        if (Config.Baked.temperatureEnabled && (jsonConsumableBlockTemperatures = TemperatureDataManager.getConsumableBlock(blockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) != null) {
            for (JsonTemperatureConsumableBlock jtcb : jsonConsumableBlockTemperatures) {
                if (jtcb.getEffect() == null || !jtcb.matchesState(blockState)) continue;
                player.addEffect(new MobEffectInstance(jtcb.getEffectHolder(), jtcb.duration, Math.abs(jtcb.temperatureLevel) - 1, false, false, true));
                if (jtcb.getOppositeEffectHolder() == null) continue;
                player.removeEffect(jtcb.getOppositeEffectHolder());
            }
        }
    }

    @Override
    public void addTemperatureModifier(Player player, double temperature, UUID uuid) {
        HEATING_TEMPERATURE.addModifier(player, uuid, Math.max(temperature, 0.0));
        COOLING_TEMPERATURE.addModifier(player, uuid, Math.min(temperature, 0.0));
    }

    @Override
    public void addHeatResistanceModifier(Player player, double resistance, UUID uuid) {
        HEAT_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void addColdResistanceModifier(Player player, double resistance, UUID uuid) {
        COLD_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void addThermalResistanceModifier(Player player, double resistance, UUID uuid) {
        THERMAL_RESISTANCE.addModifier(player, uuid, resistance);
    }

    @Override
    public void setArmorCoatTag(ItemStack stack, String coatId) {
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compound = custom != null ? custom.copyTag() : new CompoundTag();
        compound.putString(COAT_TAG, coatId);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    @Override
    public float clampTemperature(float temperature) {
        return Mth.clamp((float)temperature, (float)TemperatureEnum.FROSTBITE.getLowerBound(), (float)TemperatureEnum.HEAT_STROKE.getUpperBound());
    }

    @Override
    public String getArmorCoatTag(ItemStack stack) {
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (custom != null) {
            CompoundTag compound = custom.copyTag();
            if (compound.contains("ArmorPadding")) {
                compound.putString(COAT_TAG, compound.getString("ArmorPadding"));
                compound.remove("ArmorPadding");
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
            }
            if (compound.contains(COAT_TAG)) {
                return compound.getString(COAT_TAG);
            }
        }
        return "";
    }

    @Override
    public void removeArmorCoatTag(ItemStack stack) {
        CompoundTag compound;
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (custom != null && (compound = custom.copyTag()).contains(COAT_TAG)) {
            compound.remove(COAT_TAG);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
        }
    }

    static {
        equipmentSlotTemperatureUuid.put(EquipmentSlot.HEAD, UUID.fromString("06e30f27-2340-4bdb-9a91-a657f1e2880f"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.CHEST, UUID.fromString("1e7ef99e-2fe7-4edc-95b1-27fa056eae6d"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.LEGS, UUID.fromString("f46c0aff-7381-4f99-890e-75eb3781af21"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.FEET, UUID.fromString("34f98220-a7d9-4cc1-8930-b3dc4115ad07"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.MAINHAND, UUID.fromString("7b1e1c2c-746c-4631-8037-f76c82529909"));
        equipmentSlotTemperatureUuid.put(EquipmentSlot.OFFHAND, UUID.fromString("389caa2f-2c18-49da-b521-b53cc5713e14"));
    }
}

