/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.type;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.ClassTarget;
import org.sinytra.adapter.next.env.ann.RedirectMixinData;
import org.sinytra.adapter.next.env.param.MethodParameters;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.type.MixinType;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class RedirectMixin
implements MixinType<RedirectMixinData> {
    @Override
    public RedirectMixinData parse(MixinContext context, ClassTarget targetClass, MethodQualifier targetMethod, AtData atData, AnnotationHandle handle) {
        return new RedirectMixinData(targetClass, targetMethod, atData);
    }

    @Override
    public void preProcess(RedirectMixinData mixin, MixinContext context, MutableConfiguration clean, Recipe recipe) {
        if (clean.getAtData() == null || !"INVOKE".equals(clean.getAtData().getValue())) {
            return;
        }
        MethodQualifier targetDesc = clean.getAtData().getTarget().flatMap(MethodQualifier::create).orElse(null);
        if (targetDesc == null) {
            return;
        }
        List<Type> callTypes = MethodParameters.getParameterTypes(targetDesc.desc());
        List<Type> methodTypes = MethodParameters.getParameterTypes(context.methodNode().desc);
        ArrayList<Type> capturedMethodParams = new ArrayList<Type>(methodTypes.subList(callTypes.size(), methodTypes.size()));
        MethodParameters params = MethodParameters.builder().put(MethodParameters.ParamGroup.METHOD_PARAMS, callTypes).put(MethodParameters.ParamGroup.CAPTURED_PARAMS, capturedMethodParams).build();
        clean.setParameters(params);
    }

    @Override
    public void postProcess(RedirectMixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        if (dirty.getTargetMethod() == null) {
            return;
        }
        MethodQualifier targetDesc = dirty.getAtData().getTarget().flatMap(MethodQualifier::create).orElse(null);
        if (targetDesc == null) {
            return;
        }
        List<Type> dirtyCaptured = context.methods().resolveCapturedMethodParams(recipe.clean(), recipe.dirty());
        List<Type> callTypes = MethodParameters.getParameterTypes(targetDesc.desc());
        MethodParameters params = MethodParameters.builder().put(MethodParameters.ParamGroup.METHOD_PARAMS, callTypes).put(MethodParameters.ParamGroup.CAPTURED_PARAMS, dirtyCaptured).build();
        dirty.setParameters(params);
        dirty.setReturnType(Type.getReturnType((String)targetDesc.desc()));
    }
}

